# Library for ham contest logger Xtlf.pl by PA0R. 

# This program is published under the GPL license.
#   Copyright (C) 2006
#       Rein Couperus PA0R (rein at couperus.com)
# 
# *    tlf_lib.pl is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    tlf_lib.pl is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use Socket;
use POSIX;	

########## driver for cwdaemon ###############
$HOSTNAME = "localhost";
$PORTNO = 6789;

########## make socket #######################

socket(SOCKET, PF_INET, SOCK_DGRAM, getprotobyname("udp"))
	or die "socket: $!";
	
$ipaddr = inet_aton($HOSTNAME);
$portaddr = sockaddr_in($PORTNO, $ipaddr);

########## initialize the keyer ##############

#initialize_keyer();

#if ($sendqrv) { sendbuf("qrv"); }

1;

##############################################
sub sendbuf {
##############################################
my $txt = shift @_;

		send (SOCKET, $txt, 0, $portaddr) == length $txt
			or die "Cannot send to $HOSTNAME($PORTNO): $!";
}	
##############################################
sub rcvbuf {
##############################################

	$rin = '';
	vec($rin, fileno(SOCKET), 1) = 1;
	
	$nfound = select($rout=$rin, undef, undef, 0.005);
	if (vec ($rout, fileno (SOCKET),1)) {
			my $port = recv (SOCKET, $txt, 1024, 0) or die "Cannot recv: $!";
			return $txt;
	} else {
		return "";
	}

}	

##############################################
sub sendcwcmd {
##############################################
my ($cmd, $value) = @_;
my $cwdEsc = "\033";

if (!$value) { $value = 30; }	
	$txt = sprintf("%s%s%d", $cwdEsc,$cmd,$value);

	sendbuf($txt);

}
##############################################
sub initialize_keyer {
##############################################
sendcwcmd("2", $cwdWpm);
sendcwcmd("7", $cwdWeight);
sendcwcmd("3", $cwdSideTone);
sendcwcmd("g", $cwdVolume);
sendcwcmd("d", $cwdDelay);

}
##############################################



############################################
sub makehash {
############################################

open (CM, "$ENV{HOME}/.xtlf/callmaster") or die "Cannot open callmaster file";
my @calls_file = <CM>;
close (CM);

my $i;

	foreach my $call (@calls_file) {
		chomp $call;
		addcall($call);
	}
}
############################################
sub addcall {
############################################
my $call = shift @_;

	if (exists($checkcalls{$call})) {
		return;
	}

		my $lcall = length $call;
		push ( @ {$checkcalls{$call} }, $call);
		push ( @ {$checkcalls{substr($call, 0, 2)}}, $call);
		for ($i = 0; $i <= $lcall - 3 ; $i++) {
			push (@{$checkcalls{substr ($call, $i, 3)}}, $call);
		}
		if ($lcall > 3) {
			for ($i = 0; $i < $lcall - 4 ; $i++) {
				push (@{$checkcalls{substr ($call, $i, 4)}}, $call);
			}
		}
		if ($lcall > 4) {
			for ($i = 0; $i < $lcall - 5 ; $i++) {
				push (@{$checkcalls{substr ($call, $i, 5)}}, $call);
			}
		}
		if ($lcall > 5) {
			for ($i = 0; $i < $lcall - 6 ; $i++) {
				push (@{$checkcalls{substr ($call, $i, 6)}}, $call);
			}
		}	
		if ($lcall > 6) {
			for ($i = 0; $i < $lcall - 7 ; $i++) {
				push (@{$checkcalls{substr ($call, $i, 7)}}, $call);
			}
		}	
		if ($lcall > 7) {
			for ($i = 0; $i < $lcall - 8 ; $i++) {
				push (@{$checkcalls{substr ($call, $i, 8)}}, $call);
			}
		}
}
############################################
sub callcheck {
############################################
	my $call = shift @_;
	my $out = "";
	
	if (exists($checkcalls{$call})) {
		my @list =  @{$checkcalls{$call}};
		foreach $call (@list) {
			chomp $call;
			$out .= ' ';
			$out .= $call;
		}
		return substr($out, 0, 180);
	}

}
############################################
sub makedate {
############################################
	my ($Band, $Mode, $Qsonum) = @_;
	
	my ($seconds, $minutes, $hours, $day_of_month, $month, $year) = gmtime(time);
	$seconds = 0;
	my @pmonths = qw(Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec);
	my $months = $pmonths[$month];
	my $days = substr ("00". $day_of_month, -2,2);
	my $years = substr($year+1900, 2, 2);
	$minutes = substr("0" . $minutes, -2, 2);
	$hours = substr("0" . $hours, -2, 2);	
	my $tlf_time = sprintf("%2s-%s-%2s %2s:%2s", $days, $months, $years, $hours, $minutes);
	my $pqsonum = substr("000" . $Qsonum, -4, 4);
	my $datestring = "$Band$Mode ". $tlf_time . " $pqsonum ";

	return $datestring
}
############################################
sub makelog {
############################################
	my ($Band, $Mode, $Qsonum, $Call, $Mult1, $Mult2, $rest, $freq) = @_;
	my $line = "";
	my $Dateline = makedate ($Band, $Mode, $Qsonum);

	$line = sprintf ("%s %s            ",$Dateline, $Call);
	my $pline = substr($line, 0, 44);
	$line = sprintf ("%s599  599  %s %s %s",$pline,$Mult1, $Mult2, $rest);
	$line .= "                              ";
	$line = substr($line, 0, 84);
	if (defined ($freq)) { $line .= $freq;}
	$line .= "\n";
	addsearchtable($line);
	
	push @qso10, time(); # for the rate meter
	push @qso100, time();
		
	return $line
}

############################################
sub addlog {
############################################

	my $line = shift @_;
	
	my $log = ">>" . $logfile;
	open (QF, $log) or die "Cannot open qso file";
	print QF $line;
	close (QF);
}

############################################
sub readlog {
############################################
my @log;

eval {
	open (IF, "<", $logfile) or die "Cannot find logfile";;
	@log = <IF>;
	close (IF);
};
if ($@) {
	errormsg("$@");
}

my $lastline = $#log;
eval {
	if($log[$lastline]) {
		$Qsonum = substr($log[$lastline], 23, 4);
		$Qsonum++;
	} else {
		$Qsonum = 1;
	}
};

foreach my $line (@log) {
	if (length ($line) > 30) {
		$call = substr ($line, 29, 13);
		$call =~ /(\w*\/*\w*\/*\w*)\s+/;
		$call = $1;
		addcall($call);
		addsearchtable($line);
	}
}

my $outline = join '', @log;

return $outline;
}

{ # searchlog 
%searchtable_160 = ();
%searchtable_80 = ();
%searchtable_40 = ();
%searchtable_20 = ();
%searchtable_15 = ();
%searchtable_10 = ();
############################################
sub addsearchtable {
############################################
my $line = shift @_;
my $i;

	my $Band = substr($line, 0, 3);
	my $Callfield = substr($line, 29, 13);
	if ($Callfield =~ /(\w*\/*\w*\/*\w*)\s+/){
		$Call = $1;
	}
	my $bnd_md = substr($line, 0, 9);
	my $qtime = substr($line, 17, 26);
	my $mults = substr($line, 54, 20);
	my $qsoinfo = sprintf("%s/%s%s", $bnd_md, $qtime, $mults);
	chomp $qsoinfo;

	if ($Band eq "160") {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_160{$frag} = $qsoinfo;
		}
	} elsif ($Band eq " 80") {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_80{$frag} = $qsoinfo;
		}
	} elsif ($Band eq " 40") {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_40{$frag} = $qsoinfo;
		}
	} elsif ($Band eq " 20") {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_20{$frag} = $qsoinfo;
		}
	} elsif ($Band eq " 15") {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_15{$frag} = $qsoinfo;
		}
	} else {
		for ($i = 2; $i <= length $Call; $i++) {
			$frag = substr($Call,0, $i);
			$searchtable_10{$frag} = $qsoinfo;
		}
	}

}

############################################
sub searchtable {
############################################
my ($Band, $Call) = @_;

	if ($Band eq "160") {
		if (exists $searchtable_160{$Call}) {
			my $qline = $searchtable_160{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} elsif ($Band eq " 80") {
		if (exists $searchtable_80{$Call}) {
			my $qline = $searchtable_80{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} elsif ($Band eq " 40") {
		if (exists $searchtable_40{$Call}) {
			my $qline = $searchtable_40{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} elsif ($Band eq " 20") {
		if (exists $searchtable_20{$Call}) {
			my $qline = $searchtable_20{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} elsif ($Band eq " 15") {
		if (exists $searchtable_15{$Call}) {
			my $qline = $searchtable_15{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} elsif ($Band eq " 10") {
		if (exists $searchtable_10{$Call}) {
			my $qline = $searchtable_10{$Call};
			$qline .= "                   ";
			return substr($qline, 0, 50);
		} else {
			return "";
		}
	} else {
		return "";
	}


}
} # searchlog end

###################################################
sub checkmults {
###################################################
my $band = shift @_;
my @info = @_;
my @mults = ();
my $dblmult = -1;
my $secondmult = "";

if ($mult2 eq "cqzone") {
	$dblmult = checkcqzone ($info[10], $band, $call);
	if ($dblmult == 0 && length ($call) > 2) {
		$secondmult = " & ZONE!!\n";
	} else {
		$secondmult = "";
	}
}

if ($mult1 eq "country") {

#	@mults = ();
	push @mults, checkcountry($info[10], $band);
	push @mults, "COUNTRY" . $secondmult;
	
	foreach my $band ("160", " 80", " 40", " 20", " 15", " 10") {
		my $nrworked = checkcountry($info[10],$band);
		push @mults, $nrworked;
	}
	return @mults;
	
} elsif ($mult1 eq "ituzone") {
	$dblmult = checkituzone ($info[10], $band, $call);
	if ($dblmult == 0 && length ($call) > 2) {
		$secondmult = " ITU ZONE!!\n";
	} else {
		$secondmult = "";
	}
	push @mults, $dblmult;
	push @mults, $secondmult;
	return @mults;

} elsif ($mult1 eq "prefix") {
	@mults = ();
	push @mults, checkprefix($info[8]);
	push @mults, "PREFIX";
	$mults[0] = 0 unless defined ($mults[0]);
	
	return @mults;
}

return (-1);

}

###################################################
sub deletelastqso {
###################################################

open ($fh, "+<", $logfile) or die "Cannot open log file $!";
my $addr;
while (<$fh>) {
	$addr = tell($fh) unless eof($fh);
}
if ($addr) {
	truncate ($fh, $addr) or die "Cannot truncate log file $!";
}
close ($fh);

}
###################################################

{ # start spots
@spots_160 = ();
@spots_80 = ();
@spots_40 = ();
@spots_30 = ();
@spots_20 = ();
@spots_17 = ();
@spots_15 = ();
@spots_12 = ();
@spots_10 = ();
@spots_allband = ();
###################################################
sub clusterspots {
###################################################
my ($line, $Band) = @_; 

		$maxspotdur = 30;
		my $i = 0;
		my @str = ();
		
		$dxqrg = 0;
		$dxspot = "";
		$dxtime = 0;
		my $day;
		my $outline;
		my $Searchcall;
		$qsofound = 0;
		my $toolate = "";
			
		if ($line) {
				if ($line =~ /^DX de /) { return; }
				if ($line =~ /^To ALL /) { return; }
				if (length $line < 100) { return; }
			
				$day = substr ($line, 8, 2);
				$realdate = `date -u`;
				$realday = substr ($realdate, 8, 2);
				if ($realday != $day) { return; };
				
				
				$dxqrg = substr($line, 43, 7) ;
				$dxspot = substr($line, 52, 13) ;
				$dxtime = substr($line, 96, 4) ;
				
				if ($dxqrg > 30000) { return;}
				
				if ($dxspot =~ /(\w*\/*\w*\/*\w*)\s+/) {
					$Searchcall =  $1;
				}
				$qsoinfo = searchtable($Band, $Searchcall);

				if ($qsoinfo) {
					$qsofound = 1;
				}

			$outline = $dxqrg . "  " . $dxspot . " " . $dxtime . "\n";
			
			$diff = oldspots($outline);
			$too_late = 0;
			if ($diff > $maxspotdur) {
					$too_late = 1; 
			} 
			
		
			foreach my $spot (@spots_allband) {
				$diff = oldspots($spot);
				unless ($dxspot eq substr($spot, 9, 13)){
					if ($diff < $maxspotdur) {
						unless ($dxqrg == substr($spot, 0, 7)) {
							push @str, $spot; 
						}
					}
				}
			}
			@spots_allband = @str;
			push @spots_allband, $outline unless $too_late;
			@str = ();

			if ($dxqrg > 1799.9 && $dxqrg < 2000.0) {
				foreach my $spot (@spots_160) {
					@str = addspot($spot, @str);
				}
				@spots_160 = @str;
				push @spots_160, $outline unless $too_late;
			} elsif ($dxqrg > 3499.9 && $dxqrg < 4000.0) {
				foreach my $spot (@spots_80){
					@str = addspot($spot, @str);
				}
				@spots_80 = @str;
				push @spots_80, $outline unless $too_late;
			} elsif ($dxqrg > 6999.9 && $dxqrg < 7200.0) {
				foreach my $spot (@spots_40){
					@str = addspot($spot, @str);
				}
				@spots_40 = @str;
				push @spots_40, $outline unless $too_late;
			} elsif ($dxqrg > 13999.9 && $dxqrg < 14350.0) {
				foreach my $spot (@spots_20){
					@str = addspot($spot, @str);
				}
				@spots_20 = @str;
					push @spots_20, $outline unless $too_late;
			} elsif ($dxqrg > 10099.9 && $dxqrg < 10150.0) {
				foreach my $spot (@spots_30){
					@str = addspot($spot, @str);
				}
				@spots_30 = @str;
				push @spots_30, $outline unless $too_late;
			} elsif ($dxqrg > 18067.9 && $dxqrg < 18168.0) {
				foreach my $spot (@spots_17){
					@str = addspot($spot, @str);
				}
				@spots_17 = @str;
				push @spots_17, $outline unless $too_late;
			}elsif ($dxqrg > 24889.9 && $dxqrg < 24990.0) {
				foreach my $spot (@spots_12){
					@str = addspot($spot, @str);
				}
				@spots_12 = @str;
				push @spots_12, $outline unless $too_late;
			} elsif ($dxqrg > 20999.9 && $dxqrg < 21450.0) {
				foreach my $spot (@spots_15){
					@str = addspot($spot, @str);
				}
				@spots_15 = @str;
				push @spots_15, $outline unless $too_late;
			} elsif ($dxqrg > 27999.9 && $dxqrg < 30000.0) {
				foreach my $spot (@spots_10){
					@str = addspot($spot, @str);
				}
				@spots_10 = @str;
				push @spots_10, $outline unless $too_late;
			}
			@str = ();
		}		
		
		if ($Allbandspots) {
			@sorted = @spots_allband;
		} elsif ($Band eq "160") {
			@sorted = sort  @spots_160;
		} elsif ($Band eq " 80"){
			@sorted = sort  @spots_80;
		} elsif ($Band eq " 40"){
			@sorted = sort  @spots_40;
		} elsif ($Band eq " 30"){
			@sorted = sort  @spots_30;
		} elsif ($Band eq " 20"){
			@sorted = sort  @spots_20;
		} elsif ($Band eq " 17"){
			@sorted = sort  @spots_17;
		} elsif ($Band eq " 15"){
			@sorted = sort  @spots_15;
		} elsif ($Band eq " 12"){
			@sorted = sort  @spots_12;
		} elsif ($Band eq " 10"){
			@sorted = sort  @spots_10;
		}
								
		@{$slist->{data}} = ();
				
		if ($Allbandspots ) {
			my @str = ();
			for ($i = 0; $i <= $#sorted; $i++) {
				$outstring = $sorted[$i];
				if ($outstring) { chomp $outstring; }
				push @str, [$outstring];
				@{$slist->{data}} = reverse @str; 
			}	
		} else {
			foreach $outstring (@sorted){
				if ($outstring) { chomp $outstring; }
				
				$outstring = printspot($outstring);
				if ($outstring) {
					push @{$slist->{data}}, [$outstring];				
				}
			}
		}
		$line ="";
1;
}
} # end spots

###################################################
sub addspot {
###################################################
my ($spot, @str) = @_;
	$diff = oldspots($spot);
	my $newspot = substr($spot, 9, 13);
	unless ($dxspot eq $newspot){
		
		
		if ($diff < $maxspotdur) {
			unless ($dxqrg == substr($spot, 0, 7)) {
					push @str, $spot;
			}
		}
	}
	return @str;
}
###################################################
sub checkspotmult {
###################################################
	my $spot = shift @_;
	my @info = getinfo($spot);
	my @mults = checkmults($Band, @info);
	if ($mults[0] == 0) {
		return 0;
	}
	return 1;
}

###################################################
sub printspot {
###################################################
my $spot = shift @_;
$multsonly = 1;
my $dx = substr($spot, 9, 13) ;

$dx =~ m/(\w*\/*\w*\/*\w*)\s+/; 

	$qsoinfo = searchtable($Band, $1);
	if ($qsoinfo && $spots_new) { return ""; }
	
	my $isnomult = checkspotmult($dx);
	
	if ($mults_only &&  $isnomult) { return ""; }
	
#	showmsg($spot);


return $spot

}

###################################################
sub oldspots {
###################################################

my $spot = shift @_;

my $dxhour = substr($spot, 23,2);
my $dxmin = substr($spot, 25,2);
my $dxtime = 60 * $dxhour + $dxmin;

($hour, $minute) = (gmtime)[2,1];
my $spottime = 60 * $hour + $minute;

my $diff = $spottime - $dxtime;

$diff += 5;

if ($diff < 0) { 
	$diff += 60;	
}
if ($diff < 0) {
	$diff = 60;
} 

return $diff;
	
}

###################################################
sub showband {
###################################################
	my $Band = shift @_;
	
	my $qrg = "";
	
	if (exists $freqmemory{$Band})  {
		$Qrg = $freqmemory{$Band};	
	} else {
		if ($Band eq "160") {
			$Qrg =" 1800.0";
			$Bandindex = 0;
		} elsif ($Band eq " 80") {
			$Qrg = " 3500.0";
			$Bandindex = 1;
		} elsif ($Band eq " 40") {
			$Qrg = " 7000.0";
			$Bandindex = 2;
		} elsif ($Band eq " 30") {
			$Qrg = "10100.0";
			$Bandindex = 3;
		} elsif ($Band eq " 20") {
			$Qrg = "14000.0";
			$Bandindex = 4;
		} elsif ($Band eq " 17") {
			$Qrg = "18060.0";
			$Bandindex = 5;
		} elsif ($Band eq " 15") {
			$Qrg = "21000.0";
			$Bandindex = 6;
		} elsif ($Band eq " 12") {
			$Qrg = "24890.0";
			$Bandindex = 7;
		} elsif ($Band eq " 10") {
			$Qrg = "28000.0";
			$Bandindex = 8;
		}
	}
	$Qrgentry->set_text($Qrg);

	my $showfreq = $Qrg;
	
	if ($mults_only && ! $Allbandspots) {
		$showfreq .= " Mults";
	}
	

	$Dxspots->set_title($showfreq);
}
###################################################
sub get_trx {
###################################################
		my $rigmodel = $Rigmodelentry->get_text;
		my $speed = $Speedentry->get_text;
		my $device = $Deviceentry->get_text;
		my $result;
		my $cmd = sprintf("rigctl -m %d -r %s -s %d f 2>/dev/null\n", 
			$rigmodel, $device, $speed);
		eval { 
			$result = `$cmd` or die "Comms error $!\n";
		};
		if ($@) { 
#			errormsg ($@);
			return 9999;
		}
		if ($result =~ /get_freq/) {
			return 0;
		} else {
			return $result;
		}
}
###################################################
sub get_trx_mode {
###################################################
		my $rigmodel = $Rigmodelentry->get_text;
		my $speed = $Speedentry->get_text;
		my $device = $Deviceentry->get_text;
		my $result;
		my $cmd = sprintf("rigctl -m %d -r %s -s %d m 2>/dev/null\n", 
			$rigmodel, $device, $speed);
		eval { 
			$result = `$cmd` or die "Comms error $!\n";
		};
		if ($@) { 
			errormsg ($@);
			return 9999;
		}
		if ($result =~ /(\w*)\n(\d*)/){
			my $out = "$1,$2";
			return $out;
		} else {
			return "";
		}

}
###################################################
sub set_trx {
###################################################
my $freq = shift @_;
	if ($trxcontrol){
		$freq *= 1000;
		my $rigmodel = $Rigmodelentry->get_text;
		my $speed = $Speedentry->get_text;
		my $device = $Deviceentry->get_text;
		my $result;
		my $cmd = sprintf("rigctl -m %d -r %s -s %d F %d 2>/dev/null\n", 
			$rigmodel, $device, $speed, $freq);
		eval { 
			$result = `$cmd` or die "Comms error $!\n";
		};
		if ($@) { 
			errormsg ($@);
			return 0;
		}
		return $result;
	}
}
###################################################
sub set_trx_mode{
###################################################
my ($mode, $bw) = @_;

	if ($trxcontrol){
		my $rigmodel = $Rigmodelentry->get_text;
		my $speed = $Speedentry->get_text;
		my $device = $Deviceentry->get_text;
		my $result;
		my $cmd = sprintf("rigctl -m %d -r %s -s %d M %s %d 2>/dev/null\n", 
			$rigmodel, $device, $speed, $mode, $bw);
		eval { 
			$result = `$cmd` or die "Comms error $!\n";
		};
		if ($@) { 
			errormsg ($@);
			return 0;
		}
		return $result;
	}
}
###################################################
sub loadmessages {
###################################################

	my @messages = ();
	eval {
		open ($fh, "$ENV{HOME}/.xtlf/messages") or die "Cannot find messages\n";
		while (<$fh>) {
			if (/=(.*)/) {
				push @messages, $1;
			}
		}
		close ($fh);
		$F1txt = $messages[0];
		$F2txt = $messages[1];
		$F3txt = $messages[2];
		$F4txt = $messages[3];
		$F5txt = $messages[4];
		$F6txt = $messages[5];
		$F7txt = $messages[6];
		$F8txt = $messages[7];
		$F9txt = $messages[8];
		$F10txt = $messages[9];
		$F11txt = $messages[10];
		$F12txt = $messages[11];
		$TUmesg = $messages[12];
		$SPTUmesg = $messages[13];
	};
	if ($@) {
		print $@;
	}
}
###################################################
sub loadsummarydata {
###################################################

	my @messages = ();
	eval {
		open ($fh, "$ENV{HOME}/.xtlf/summarydata") or die "Cannot find summary\n";
		while (<$fh>) {
			if (/=(.*)/) {
				push @messages, $1;
			}
		}
		close ($fh);
		$Sumcall->set_text($messages[0]);
		$Sumsection->set_text($messages[1]);
		$Sumop_cat->set_text($messages[2]);
		$Sumfreq->set_text($messages[3]);
		$Sumpwr->set_text($messages[4]);
		$Summode->set_text($messages[5]);
		$Sumass->set_text($messages[6]);
		$Sumcontest->set_text($messages[7]);
		$Sumopentry->set_text($messages[8]);
		$Sumoverlay->set_text($messages[9]);
		$Sumnameentry->set_text($messages[10]);
		$Sumadds1->set_text($messages[11]);
		$Sumadds2->set_text($messages[12]);
		$Sumadds3->set_text($messages[13]);
		$Sumemail->set_text($messages[14]);
		$Sumsb1->set_text($messages[15]);
		$Sumdxp->set_text($messages[16]);
		$Sumtime->set_text($messages[17]);
		$Sumisl->set_text($messages[18]);
		$Sumclub->set_text($messages[19]);
	};
	if ($@) {
		print $@;
	}
}

###################################################
sub loadkeyer {
###################################################

	eval {
		my @messages = ();
		open ($fh, "$ENV{HOME}/.xtlf/cwdaemon_defaults") or die "Cannot find data\n";
		while (<$fh>) {
			if (/=(.*)/) {
				push @messages, $1;
			}
		}
		close ($fh);
		
		$cwdaemon = $messages[0];
		$sendqrv = $messages[1];
		$cwdWpm = $messages[2];
		$cwdWeight = $messages[3];
		$cwdSideTone = $messages[4];
		$cwdVolume = $messages[5];
		$cwdDelay = $messages[6];
		$autocq_delay = $messages[7];
		$autostart = $messages[8];
	};
	if ($@) {
		print $@;
	}
}

###################################################
sub loadinterfaceconfig {
###################################################

	eval {
		my @messages = ();
		open ($fh, "$ENV{HOME}/.xtlf/trxcontrol") or die "Cannot find data\n";
		while (<$fh>) {
			if (/=(.*)/) {
				push @messages, $1;
			}
		}
		close ($fh);
		
		$trxcontrol = $messages[0];
		$rigmodel = $messages[1];
		$rigspeed = $messages[2];
		$rigdevice = $messages[3];
		
		if ($trxcontrol) {
			$Trxctlonbutton->set_active(1);
		} else {
			$Trxctlonbutton->set_active(0);
		}
		$Rigmodelentry->set_text($rigmodel);
		$Speedentry->set_text($rigspeed);
		$Deviceentry->set_text($rigdevice);
	};
	if ($@) {
		print $@;
	}
}


$trlogfile = "";
$adiflogfile = "";
$cabrillologfile = "";
###################################################
sub loadlogfilenames {
###################################################
	my $input = "";

	eval {
		my @messages = ();
		open ($fh, "<", "$ENV{HOME}/.xtlf/logfiles") or die "Cannot find logfiles\n";
		while (<$fh>) {
			if (/=(~*)(.*)/) {
				if ($1) {
					$input = "$ENV{HOME}" . $2;
				} else {
					$input = $2;
				}
				push @messages, $input;
			}
		}
		close ($fh);
		
		$trlog_file = $messages[0];
		$adiflogfile = $messages[1];
		$cabrillologfile = $messages[2];
		$standardexchange = $messages[3];
		
		
		$TRlogentry->set_text($trlog_file);
		$Adifentry->set_text($adiflogfile);
		$Cabrilloentry->set_text($cabrillologfile);
		$Stdexchangeentry->set_text($standardexchange);

	};
	if ($@) {
		print $@;
	}
}


###################################################
sub getband {
###################################################
	my $freq = shift @_;
	
	if ($freq < 3500) {
		$Band = "160";	
		$Bandindex = 0;
	} elsif ($freq < 7000) {
		$Band = " 80";	
		$Bandindex = 1;
	} elsif ($freq < 10100) {
		$Band = " 40";	
		$Bandindex = 2;
	} elsif ($freq < 14000) {
		$Band = " 30";	
		$Bandindex = 3;
	} elsif ($freq < 18060) {
		$Band = " 20";	
		$Bandindex = 4;
	} elsif ($freq < 21000) {
		$Band = " 17";	
		$Bandindex = 5;
	} elsif ($freq < 24700) {
		$Band = " 15";	
		$Bandindex = 6;
	} elsif ($freq < 28000) {
		$Band = " 12";	
		$Bandindex = 7;
	} else {
		$Band = " 10";	
		$Bandindex = 8;
	} 
	return $Band;
	
}
###################################################
sub printwwv {
###################################################
 my $msg = "";

	 if (-e "$ENV{HOME}/.xdx/wwv") {
	 	my $wwvfile = "tail -n 1 " . "$ENV{HOME}/.xdx/wwv";
	 	$wwvline = `$wwvfile`;
	 	if ($wwvline =~ /(K=\d*).*(A=\d*)\s(R=\d*) (SFI=\d*)/) {
			$msg = " " . $4 . " " . $2 . " " . $1;
	 	} elsif ($wwvline =~ /(SFI=\d*).*(A=\d*).*(K=\d*)/) {
			$msg = " " . $1 ." " . $2 . " " . $3;
	 	}
	 		$msg =~ s/=/:/g;
	 		$Statusbar_wwv->pop($Context_id_wwv);
			$Statusbar_wwv->push($Context_id_wwv, $msg);
			$wwvmsg = $msg;		
	 }

}

###################################################
sub checkstatus {
###################################################
	my @status = ();
	my $clusterstatus = 0;
	my $cwdaemonstatus = 0;
	my $gmfskstatus = 0;
	
	if (-e "$ENV{HOME}/.xdx/dxspots") {
		my @rsult = `ps aux | grep xdx`;
		if ($rsult[0] =~ /xdx/ && $rsult[0] !~ /grep/) {
			$clusterstatus = 1;
		}
	} 
	my @rsult = `ps aux | grep cwdaemon`;
	if ($rsult[0] =~ /cwdaemon/ && $rsult[0] !~ /grep/) {
		$cwdaemonstatus = 1;
	}
	@rsult = `ps aux | grep gmfsk`;
	if ($rsult[0] =~ /gmfsk/ && $rsult[0] !~ /grep/){
		$gmfskstatus = 1;
	}

	push @status, $cwdaemonstatus;
	push @status, $clusterstatus;
	push @status, $gmfskstatus;
	
	return @status;
	
}
###################################################
sub showstatus {
###################################################
	my ($contestmode, $cwdaemonstatus, $clusterstatus, $gmfskstatus, $trxstatus) = @_;

	if ($contestmode) {
		$t1 = "Contest"
	} else {
		$t1 = "QSO";
	}
	if ($cwdaemonstatus) {
		$t2 = "running";
	} else {
		$t2 = "not running";
	}
	if ($clusterstatus) {
		$t3 = "XDX running";
	} else {
		$t3 = "XDX not running";
	}
	if ($gmfskstatus) {
		$t4 = "gMFSK running";
	} else {
		$t4 = "gMFSK if OFF";
	}
	if ($trxstatus) {
		$t5 = "Trx frequency control ON";
	} else {
		$t5 = "Trx frequency control not running";
	}
	$retval = sprintf ("System status:\n\nOperation mode: $t1\nCwdaemon $t2\n$t3\n$t4\n$t5");	

	$Statuslabel->set_text($retval);	
}
1;
