/*
 * Copyright (c) 1998, 1999, Bjorn Lindgren <bjorn@500mhz.net>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by
 *      Bjorn Lindgren <bjorn@500mhz.net>.
 * 4. Neither the name of the authors nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

static const char rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <xwhois.h>

__BEGIN_DECLS

void scan_servers __P((void));
void scan_forknpipe __P((void));
void scan_pthreads __P((void));
void *scan_pthreads_t __P((void *));

__END_DECLS

char *obuf; /* out buffer containing data from all threads */
int num; /* number of whois servers */

void
scan_servers(void)
{
  num = getsrvnum();
  obuf = malloc(1000000);

#ifdef FORKNPIPE
  scan_forknpipe();
#else /* !FORKNPIPE */
#ifdef HAVE_PTHREAD_H
  scan_pthreads();
#else /* !HAVE_PTHREAD_H */
  scan_forknpipe();
#endif /* HAVE_PTHREAD_H */
#endif /* FORKNPIPE */
  free(obuf);
}

void
scan_forknpipe(void)
{
  pid_t *pid = malloc(num * sizeof(pid_t));
  char cbuf[102400]; /* child data buffer */
  char tbuf[256]; /* tmp data buffer */
  char *ptr;
  int **pipefd = malloc(num * (sizeof(int) * 2));
  int i, rc;

  for (i=0 ; i < num ; i++)
    {
      /* first we open a pipe to the parent process
       * this should maybe be rewritten to use more effective
       * fullduplex stream pipes IPC (s_pipe()) later I guess.
       */
      pipefd[i] = malloc(2 * sizeof(int)); 
      if (pipe(pipefd[i]) != 0)
	{
	  perror("pipe");
	}

      /* then we fork the childs processes */
      if ((pid[i] = fork()) == 0)
	{
#ifdef DEBUG
	  fprintf(stderr, "*** scanner() *** forked child: %d, pid: %d\n",
		  i, getpid());
#endif /* DEBUG */
	  ptr = servers[i].name;
	  /*
	  printf("child %d with parent %d has been assigned server: %s\n",
		 getpid(), getppid(), ptr);
	  */
	  /*
	  printf("Data from thread %d:\n%s\n",
		 getpid(), probe_internal(ptr, i));
	  */
	  sprintf(cbuf, "%s", probe_internal(ptr, i));
	  write(pipefd[i][1], cbuf, strlen(cbuf));
	  close(pipefd[i][0]);
	  close(pipefd[i][1]);
	  kill(getpid(), SIGKILL);
	}
    }

  /* close all unneeded pipe file descriptors */
  for (i=0 ; i < num ; i++)
    {
      close(pipefd[i][1]);
    }

  /* read the data from all child processes pipe file descriptors */
  for (i=0 ; i < num ; i++)
    {
      sprintf(obuf, "%s*** %s ***\n", obuf, servers[i].name);
      memset(tbuf, 0, sizeof(tbuf)); /* initialize the buffer */
      while (read(pipefd[i][0], tbuf, 255) != 0)
	{
	  tbuf[strlen(tbuf)]='\0';
	  sprintf(obuf,"%s%s", obuf, tbuf);
	  if (tbuf[strlen(tbuf)] == '\0')
	    {
	      break;
	    }
	  memset(tbuf, 0, sizeof(tbuf));
	}
      sprintf(obuf, "%s\n\n", obuf);
      close(pipefd[i][0]);
      /*      close(pipefd[i][1]); */
    }

  for (i=0 ; i < num ; i++)
    {
      /*      rc = waitpid(pid[i], NULL, WUNTRACED); */
      rc = waitpid(-1, NULL, WUNTRACED);
      /*      printf("got return code from child %d\n", rc); */
    }

  set_text_list(obuf);
  return;
}

#ifndef FORKNPIPE
#ifdef HAVE_PTHREAD_H
void
scan_pthreads(void)
{
  pthread_t *tid = malloc(num * sizeof(pthread_t));
  int i;

  for (i=0 ; i < num ; i++)
    {
      pthread_create(&tid[i], NULL, scan_pthreads_t,(void *) i);
    }

  for (i=0 ; i < num ; i++)
    {
      if (pthread_join(tid[i], NULL) != 0)
	{
	  perror("pthread_join");
	}
    }

  set_text_list(obuf);
  return;
}
#endif /* HAVE_PTHREAD_H */
#endif /* FORKNPIPE */

#ifndef FORKNPIPE
#ifdef HAVE_PTHREAD_H
void *
scan_pthreads_t(void *arg)
{
  int i = (int) arg;

#ifdef DEBUG
  fprintf(stderr, "*** scan_pthread_t() *** thread: %d, tid: %d\n", i,
	  (int) pthread_self());
#endif /* DEBUG */

  sprintf(obuf, "%s*** %s ***\n%s\n\n", obuf, servers[i].name,
	  probe_internal(servers[i].name, i));

  return NULL;
}
#endif /* HAVE_PTHREAD_H */
#endif /* FORKNPIPE */
