/***************************************************************************
 *            stuff.c
 *
 *  Sun Apr  2 12:30:15 2006
 *  Copyright  2006  Emanuele Madeo IZ0ETE
 *  Email <iz0ete@fabaris.it>
 ****************************************************************************/

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <gtk/gtk.h>
#include <glib.h>
#include <sys/stat.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>


#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "global.h"
#include "net.h"



int load_preferences()
{
FILE *fp,*sf;
struct stat statdir;
gchar *home_dir,*work_dir,*preferences_file, *stats_file;
gchar program_version_entry[100],call_entry[100],freq_entry[100],country_entry[100],state_entry[100],grid_entry[100],county_entry[100],latitude_entry[100],longitude_entry[100],comments_entry[100],server_wotadb_entry[100];
gchar port_entry[10],upload_interval_entry[10],check_update_entry[10];
int i;

home_dir = g_get_home_dir();

work_dir = g_strdup_printf("%s/.xwota",home_dir);
	
if (stat (work_dir, &statdir) == -1)
    {
      if (mkdir (work_dir, S_IRUSR | S_IWUSR | S_IXUSR) == -1){
	  //        printf("Creating ~/.%s directory.",work_dir);
		  }

    }

preferences_file = g_strdup_printf("%s/xwota.conf",work_dir);
stats_file = g_strdup_printf("%s/stats",work_dir);
	
// Non c'è la configurazione...scrivo quella di default.
	if(stat(preferences_file,&statdir) == -1)
	{
	//printf("Creating %s file.\n",preferences_file);
	
		xwota_settings.program_version = g_strdup("0.2");
		xwota_settings.call = g_strdup("NOCALL");
		xwota_settings.freq = g_strdup("");
		xwota_settings.country = g_strdup("");
		xwota_settings.state = g_strdup("");
		xwota_settings.grid = g_strdup("");
		xwota_settings.county = g_strdup("");
		xwota_settings.latitude = g_strdup("");
		xwota_settings.longitude = g_strdup("");
		xwota_settings.comments = g_strdup("");
		xwota_settings.server_wotadb = g_strdup("server1.wotadb.org");
		xwota_settings.port = g_strdup("1001");
		xwota_settings.upload_interval = g_strdup("5");
		xwota_settings.check_update = g_strdup("0");
		
				
		if((fp=fopen(preferences_file,"w"))==NULL){
		printf("Error writing preferences file !\nAborting...\n");
		exit(1);
		}
			
	//	printf("Scrivo la conf di default\n");
		fprintf(fp,"%s\n",xwota_settings.program_version);
		fprintf(fp,"%s\n",xwota_settings.call);
		fprintf(fp,"%s\n",xwota_settings.freq);
		fprintf(fp,"%s\n",xwota_settings.country);
		fprintf(fp,"%s\n",xwota_settings.state);
		fprintf(fp,"%s\n",xwota_settings.grid);
		fprintf(fp,"%s\n",xwota_settings.county);
		fprintf(fp,"%s\n",xwota_settings.latitude);
		fprintf(fp,"%s\n",xwota_settings.longitude);
		fprintf(fp,"%s\n",xwota_settings.comments);
		fprintf(fp,"%s\n",xwota_settings.server_wotadb);
		fprintf(fp,"%s\n",xwota_settings.port);
		fprintf(fp,"%s\n",xwota_settings.upload_interval);
		fprintf(fp,"%s\n",xwota_settings.check_update);
				
		fclose(fp);
		return 1;
		}
// Se c'è già la configurazione la leggo.
	//	printf("Leggo la conf.\n");
	if((fp=fopen(preferences_file,"r"))==NULL){
		printf("Error reading preferences file !\nAborting...\n");
		exit(1);
		}
	for(i=0;i<101;i++)program_version_entry[i] = '\0';	
	for(i=0;i<101;i++)call_entry[i] = '\0';
	for(i=0;i<101;i++)freq_entry[i] = '\0';	
	for(i=0;i<101;i++)country_entry[i] = '\0';
	for(i=0;i<101;i++)state_entry[i] = '\0';
	for(i=0;i<101;i++)grid_entry[i] = '\0';
	for(i=0;i<101;i++)county_entry[i] = '\0';
	for(i=0;i<101;i++)latitude_entry[i] = '\0';
	for(i=0;i<101;i++)longitude_entry[i] = '\0';
	for(i=0;i<101;i++)comments_entry[i] = '\0';
	for(i=0;i<101;i++)server_wotadb_entry[i] = '\0';
				
						
	fgets(program_version_entry,100,fp);
	fgets(call_entry,100,fp);
	fgets(freq_entry,100,fp);
	fgets(country_entry,100,fp);
	fgets(state_entry,100,fp);
	fgets(grid_entry,100,fp);
	fgets(county_entry,100,fp);
	fgets(latitude_entry,100,fp);
	fgets(longitude_entry,100,fp);
	fgets(comments_entry,100,fp);
	fgets(server_wotadb_entry,100,fp);
	fgets(port_entry,10,fp);
	fgets(upload_interval_entry,10,fp);
	fgets(check_update_entry,10,fp);
	
	g_strdelimit(program_version_entry,"\n",'\0');
	g_strdelimit(call_entry,"\n",'\0');
	g_strdelimit(freq_entry,"\n",'\0');
	g_strdelimit(country_entry,"\n",'\0');
	g_strdelimit(state_entry,"\n",'\0');
	g_strdelimit(grid_entry,"\n",'\0');
	g_strdelimit(county_entry,"\n",'\0');
	g_strdelimit(latitude_entry,"\n",'\0');
	g_strdelimit(longitude_entry,"\n",'\0');
	g_strdelimit(comments_entry,"\n",'\0');
	g_strdelimit(server_wotadb_entry,"\n",'\0');
	g_strdelimit(port_entry,"\n",'\0');
	g_strdelimit(upload_interval_entry,"\n",'\0');
	g_strdelimit(check_update_entry,"\n",'\0');
	
	
	
		xwota_settings.program_version = g_strdup(program_version_entry);
		xwota_settings.call = g_strdup(call_entry);
		xwota_settings.freq = g_strdup(freq_entry);
		xwota_settings.country = g_strdup(country_entry);
		xwota_settings.state = g_strdup(state_entry);
		xwota_settings.grid = g_strdup(grid_entry);
		xwota_settings.county = g_strdup(county_entry);
		xwota_settings.latitude = g_strdup(latitude_entry);
		xwota_settings.longitude = g_strdup(longitude_entry);
		xwota_settings.comments = g_strdup(comments_entry);
		xwota_settings.server_wotadb = g_strdup(server_wotadb_entry);
		xwota_settings.port = g_strdup(port_entry);
		xwota_settings.upload_interval = g_strdup(upload_interval_entry);
		xwota_settings.check_update = g_strdup(check_update_entry);
		
		
// Creo il file di stats_file

if(stat(stats_file,&statdir) == -1)
	{
	//printf("Creating %s file.\n",stats_file);
	if((sf=fopen(stats_file,"w"))==NULL){
//		printf("Error opening stats file !\n");
		}
		fclose(sf);
	}
	
		

		return 0;		
		
}


void save_preferences () {
FILE *fp;	
gchar *home_dir,*work_dir,*preferences_file;

home_dir = g_get_home_dir();
work_dir = g_strdup_printf("%s/.xwota",home_dir);
preferences_file = g_strdup_printf("%s/xwota.conf",work_dir);

	
		if((fp=fopen(preferences_file,"w"))==NULL){
		printf("Error opening preferences file !\nAborting...\n");
		exit(1);
		}
			
		
	//	printf("Salvo la configurazione\n");
		fprintf(fp,"%s\n",xwota_settings.program_version);
		fprintf(fp,"%s\n",xwota_settings.call);
		fprintf(fp,"%s\n",xwota_settings.freq);
		fprintf(fp,"%s\n",xwota_settings.country);
		fprintf(fp,"%s\n",xwota_settings.state);
		fprintf(fp,"%s\n",xwota_settings.grid);
		fprintf(fp,"%s\n",xwota_settings.county);
		fprintf(fp,"%s\n",xwota_settings.latitude);
		fprintf(fp,"%s\n",xwota_settings.longitude);
		fprintf(fp,"%s\n",xwota_settings.comments);
		fprintf(fp,"%s\n",xwota_settings.server_wotadb);
		fprintf(fp,"%s\n",xwota_settings.port);
		fprintf(fp,"%s\n",xwota_settings.upload_interval);
		fprintf(fp,"%s\n",xwota_settings.check_update);
				
		fclose(fp);	
	
}


void write_statusbar(char *message){

gtk_statusbar_push(statusbar1,1,message);
	
}

	void write_message_statusbar(char *message){

gtk_statusbar_push(message_statusbar,1,message);
	
}
guint automatic_upload()
{
	
	if (connection_status == 1) {
//		printf("Upload info.\n");
		on_update_button_clicked (NULL,NULL);
		return TRUE;
	}
 else {
//printf("Removing timeout.\n");
	 return FALSE;
 }
	
}

guint check_freq ()
{
	gchar *get_frequency;
	char frequency_entry[100];	
	
	if (connection_status == 1) {
	get_frequency= gtk_entry_get_text(GTK_ENTRY(frequency));
	strcpy(frequency_entry,get_frequency);
	//printf("Freq check: %s - Old Freq: %s\n",get_frequency,old_freq);
	
	if(strcmp(get_frequency,old_freq) == 0) {
		return TRUE;
	}
	else {
		
		automatic_upload();
	}
	
}
	
else {	
	return FALSE;
}
	return TRUE;
}

// COUNTRY LOOKUP
gchar *country_lookup (gchar *country_code) {

FILE *cf;
gchar *country_file;
gchar *code, *country;
gchar country_entry[50];
	
//printf("Country code %s conversion.\n",country_code);
country_file = g_strdup_printf("%s/%s/country.txt",PACKAGE_DATA_DIR,PACKAGE);
//	printf("CF : %s\n",country_file);
		if((cf=fopen(country_file,"r"))==NULL){
		printf("Error opening country file !\n");
			return country_code;
		}	
while(!feof(cf)) {
	fgets(country_entry,100,cf);
	code = strtok(country_entry," ");
	country = strtok(NULL,"");

//printf("%s %s\n",code,country);	
	if(strcmp(code,country_code) == 0) {
		return country;
	}

}
country = g_strdup("UNKNOWN");
fclose(cf);	
return country;
	
}

// DECODE MESSAGE

int decode_msg (char *msg)
  {
	
	  GtkTreeIter iter1;
	  GtkTreeStore *store;
	  GtkTreePath *path;
	  GtkWidget *spot_list;
	
char eor[5];
char *p_eor;	  
gchar *call,*freq,*country,*state,*grid,*county,*lat,*longitude,*status,*comments,*program,*f1,*f2,*d_ate,*t_ime; 
char datetime[50],latlong[50],status_comment[30],display_country[50];
char *country_name;	  
int status_digit,i;	
	 
	 strcpy(eor,"<EOR>"); 
	// printf("Decode: %s\n",msg); 
	//  printf("First char %c\n",msg[0]);
	
	  if(msg[0] == ':' )
	  {
	//  printf("Not implemented yet.\n");
		  if (msg[1] == 'M') {
			//  printf("Message received\n");
			  decode_text_message(msg);
			  
		  		return -1;
			  }
		  if (msg[1] == 'B') {
			  printf("Busy message from server\n");
		  		return -1;
			  }
		  
		  return -1;
	  }
// se non c'è il fine record
	  if ((p_eor = strstr(msg,eor)) == NULL)
	  {
		 printf("Incorrect message type\n");
	  
		  return -1;
	  }
// E' uno spot...lo decodifico.	
	  else {

	call = (gchar *)strsep (&msg, "|");
      freq = (gchar *)strsep (&msg, "|");
      country = (gchar *)strsep (&msg, "|");
      state = (gchar *)strsep (&msg, "|");
      grid = (gchar *)strsep (&msg, "|");
      county = (gchar *)strsep (&msg, "|");
      lat = (gchar *)strsep (&msg, "|");
      longitude = (gchar *)strsep (&msg, "|");
      status = (gchar *)strsep (&msg, "|");
      comments = (gchar *)strsep (&msg, "|");
      program = (gchar *)strsep (&msg, "|");
      f1 = (gchar *)strsep (&msg, "|");
      f2 = (gchar *)strsep (&msg, "|");
      d_ate = (gchar *)strsep (&msg, "|");
      t_ime = (gchar *)strsep (&msg, "|");

// se intercetto la stringa del server...salto...	
	if (strstr(call,"SERVER"))
			{
//		printf("Server WOTA...\n");
				return -1;
			}

			// Elaboro status
			
status_digit= atoi(status);
			
if(status_digit == 1) {
strcpy(status_comment,"Tuning");
	}
else if (status_digit == 2) {
strcpy(status_comment,"Listening");	
	}		

else if (status_digit == 3) {
strcpy(status_comment,"Calling");	
	}

	for(i=0;i<50;i++) display_country[i] = '\0';
	
// Elaboro il country
if(isdigit(country[0]) !=0) {
	country_name = country_lookup(country);
	for (i=0;i<50;i++) {
		if(country_name[i] == '\n')
		{
			country_name[i] = '\0';
	}
}

	//g_strdelimit(country_name,"\n",' ');
	sprintf(display_country,"%s",country_name);	
	
}
else {
	country_name = g_strdup(country);
	sprintf(display_country,"%s",country_name);
}

//printf("%s",country_name);

sprintf(latlong,"%s/%s",lat,longitude);
sprintf(datetime,"%s %s",d_ate,t_ime);

	
	
// Inserisco lo spot nella spot list
spot_list = lookup_widget(GTK_WIDGET(spot_window),"spot_list");
store = gtk_tree_view_get_model(spot_list);
gtk_tree_store_append (GTK_TREE_STORE(store), &iter1, NULL); 
gtk_tree_store_set(GTK_TREE_STORE(store),&iter1,DATETIME_COLUMN,datetime,CALL_COLUMN,call,FREQ_COLUMN,freq,COUNTRY_COLUMN,display_country,STATE_COLUMN,state,GRID_COLUMN,grid,
COUNTY_COLUMN,county,LATLONG_COLUMN,latlong,STATUS_COLUMN,status_comment,COMMENTS_COLUMN,comments,-1);


 path = gtk_tree_model_get_path (GTK_TREE_MODEL (store), &iter1);
 gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (spot_list), path,NULL, TRUE, 0.0, 1.0);
 gtk_tree_path_free (path);

	
// alimento le statistiche	
//add_to_stats(call);	
	
return 0;
	}
}


int decode_text_message(gchar *msg)
{
	  GtkTreeIter iter;
	  GtkTreeStore *store_message;
	  GtkTreePath *path;
	  GtkWidget *messages_list;
	
	gchar *from, *to, *text;	
	char date_msg[30];
	struct tm *utc;
	time_t t;

t=time(NULL);
utc = gmtime(&t);
//printf("Time: %d-%d-%d %d:%d\n",(utc->tm_year)+1900,utc->tm_mon,utc->tm_mday,utc->tm_hour,utc->tm_min);
sprintf(date_msg,"%d-%d-%d %d:%d",(utc->tm_year)+1900,utc->tm_mon,utc->tm_mday,utc->tm_hour,utc->tm_min);
	//printf("Decoding text message %s\n",msg);	
msg++;
msg++;
//printf("Now msg is %s\n",msg);

	to = (gchar *)strsep (&msg, "|");
      text = (gchar *)strsep (&msg, "|");
      from = (gchar *)strsep (&msg, "|");
	


messages_list = lookup_widget(GTK_WIDGET(messages_window),"messages_list");
store_message = gtk_tree_view_get_model(messages_list);
gtk_tree_store_append (GTK_TREE_STORE(store_message), &iter, NULL); 
gtk_tree_store_set(GTK_TREE_STORE(store_message),&iter,DATETIME_MSG_COLUMN,date_msg,MSG_FROM_COLUMN,from,MSG_TO_COLUMN,to,MESSAGE_TEXT_COLUMN,text,-1);

 path = gtk_tree_model_get_path (GTK_TREE_MODEL (store_message), &iter);
 gtk_tree_view_scroll_to_cell (GTK_TREE_VIEW (messages_list), path,NULL, TRUE, 0.0, 1.0);
 gtk_tree_path_free (path);
	
gtk_widget_show(messages_window);
	return 1;
	}
// STATS
int add_to_stats(gchar *call) {
FILE *sf;
gchar *home_dir,*work_dir,*stats_file;	
gchar call_stored[30];

home_dir = g_get_home_dir();
work_dir = g_strdup_printf("%s/.xwota",home_dir);
stats_file = g_strdup_printf("%s/stats",work_dir);

	
		if((sf=fopen(stats_file,"r"))==NULL){
//		printf("Error opening stats file !\n");
		}	
while(!feof(sf)) {
	fscanf(sf,"%s",call_stored);
	//printf("%s",call_stored);	
	if(strcmp(call,call_stored) == 0) {
		return 1;
	}
}
fclose(sf);

		if((sf=fopen(stats_file,"a"))==NULL){
//		printf("Error opening stats file !\n");
		}	
	fprintf(sf,"%s\n",call);
		fclose(sf);
	return 1;	
}

// CALL UPPERCASE

gchar *uppercase(gchar *upper) {
	
int upper_len,i;
	upper_len=strlen(upper);
	for(i=0;i<upper_len+1;i++) {
		upper[i] = toupper(upper[i]);
	}
return upper;
	
}







// CREATE SPOTLIST

GtkWidget *create_spot_list() {
	
	GtkWidget *spot_list;
	GtkTreeStore *store;
	GtkCellRenderer *renderer,*boldrenderer;
	GtkTreeViewColumn *column;
	
	
// Spot List

store = gtk_tree_store_new(10,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,
G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING);

  spot_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL(store));
  g_object_unref (G_OBJECT (store));
 
 
  renderer = gtk_cell_renderer_text_new ();
  boldrenderer = gtk_cell_renderer_text_new ();
   g_object_set (G_OBJECT (boldrenderer), "weight", "bold", NULL);
// date - time
  column = gtk_tree_view_column_new_with_attributes ("Date/Time", renderer,
                                                      "text", DATETIME_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
   
// Call

column = gtk_tree_view_column_new_with_attributes ("Call", boldrenderer,
                                                      "text", CALL_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
 // Freq
  column = gtk_tree_view_column_new_with_attributes ("Freq", renderer,
                                                      "text", FREQ_COLUMN	,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
  // Country
  column = gtk_tree_view_column_new_with_attributes ("Country", renderer,
                                                      "text", COUNTRY_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);

// State
  column = gtk_tree_view_column_new_with_attributes ("State", renderer,
                                                      "text", STATE_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
// Grid  
  column = gtk_tree_view_column_new_with_attributes ("Grid", renderer,
                                                      "text", GRID_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
// County  
  column = gtk_tree_view_column_new_with_attributes ("County", renderer,
                                                      "text", COUNTY_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
// Lat - Long  
  column = gtk_tree_view_column_new_with_attributes ("Lat/Long", renderer,
                                                      "text", LATLONG_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
//Status  
  column = gtk_tree_view_column_new_with_attributes ("Status", renderer,
                                                      "text", STATUS_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
//Comment  
  column = gtk_tree_view_column_new_with_attributes ("Comments", renderer,
                                                      "text", COMMENTS_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (spot_list), column);
  

	return spot_list;
	
}


GtkWidget *create_messages_list() {

	GtkWidget *messages_list;
	GtkTreeStore *store_message;
	GtkCellRenderer *renderer,*boldrenderer;
	GtkTreeViewColumn *column;
	GObject *msg_selection;
	
	
	
store_message = gtk_tree_store_new(4,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING,G_TYPE_STRING);
messages_list = gtk_tree_view_new_with_model (GTK_TREE_MODEL(store_message));
 
	g_object_unref (G_OBJECT (store_message));
 
 
  renderer = gtk_cell_renderer_text_new ();
  boldrenderer = gtk_cell_renderer_text_new ();
   g_object_set (G_OBJECT (boldrenderer), "weight", "bold", NULL);
// date - time
  column = gtk_tree_view_column_new_with_attributes ("Date/Time", renderer,
                                                      "text", DATETIME_MSG_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (messages_list), column);
	
	column = gtk_tree_view_column_new_with_attributes ("From", boldrenderer,
                                                      "text", MSG_FROM_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (messages_list), column);
  
  column = gtk_tree_view_column_new_with_attributes ("To", boldrenderer,
                                                      "text", MSG_TO_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (messages_list), column);
  
  column = gtk_tree_view_column_new_with_attributes ("Message", renderer,
                                                      "text", MESSAGE_TEXT_COLUMN,
                                                      NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (messages_list), column);
	
	msg_selection = gtk_tree_view_get_selection(messages_list);
	g_signal_connect (msg_selection, "changed", G_CALLBACK (message_selected), NULL);

return messages_list;	
}


void write_manual (GtkWidget *manual_text) {

FILE *mf;
	 GtkTextBuffer *buffer;
        GtkTextIter iter;
	gchar buf[100];
	gchar *manual_file;
	
	manual_file = g_strdup_printf("%s/README",PACKAGE_DOC_DIR);
	
		buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(manual_text));
        gtk_text_buffer_get_start_iter (buffer, &iter);

	if((mf=fopen(manual_file,"r"))==NULL){
		printf("Error reading manual file !\n");
		return;
		}
	while(!feof(mf)) {
		 if (fgets (buf, 100, mf) == NULL)
                                break;
                        else
                        {
                          
                                gtk_text_buffer_insert (buffer, &iter, buf, -1);
                   
							}
	}
}
