/* -*- c-file-style: "xxdiff" -*- */
/******************************************************************************\
 * $RCSfile: diffs.inline.h,v $
 *
 * Copyright (C) 1999-2002  Martin Blais <blais@iro.umontreal.ca>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

/*==============================================================================
 * EXTERNAL DECLARATIONS
 *============================================================================*/


XX_NAMESPACE_BEGIN


/*==============================================================================
 * CLASS XxDiffs
 *============================================================================*/

//------------------------------------------------------------------------------
//
inline XxDln XxDiffs::getNbLines() const
{
   return _lines.size() - 1;
}

//------------------------------------------------------------------------------
//
inline const XxLine& XxDiffs::getLine( const XxDln lineno ) const
{
#ifdef XX_DEBUG
   if ( !( lineno > 0 && lineno <= getNbLines() ) ) {
      XX_TRACE( lineno );
   }
#endif
   XX_CHECK( lineno > 0 && lineno <= getNbLines() );
   return _lines[ lineno ];
}

//------------------------------------------------------------------------------
//
inline XxLine& XxDiffs::getLineNC( const XxDln lineno )
{
   XX_CHECK( lineno > 0 && lineno <= getNbLines() );
   return _lines[ lineno ];
}

//------------------------------------------------------------------------------
//
inline void XxDiffs::clearDirty()
{
   _dirty = false;
}

//------------------------------------------------------------------------------
//
inline bool XxDiffs::isDirty() const
{
   return _dirty;
}

//------------------------------------------------------------------------------
//
inline bool XxDiffs::isDirectoryDiff() const
{
   return _isDirectoryDiff;
}

XX_NAMESPACE_END
