#ifndef __PHOTON_H
#define __PHOTON_H

#ifdef HAVE_CONFIG_H
#include<config.h>
#endif

#include "object3d.h"
#include "hash3d.h"
#include "params.h"
#include "scene.h"

__BEGIN_YAFRAY

class storedPhoton_t;

class runningPhoton_t
{
	friend class storedPhoton_t;
	public:
		runningPhoton_t(const color_t &color,const point3d_t &_pos)
		{pos=_pos;c=color;};
		const point3d_t & position()const {return pos;};
		void position(const point3d_t &_pos,PFLOAT bias=0);
		point3d_t lastPosition()const {return lastpos;};
		void filter(const color_t & color) {c=c*color;};
		const runningPhoton_t & operator = ( const runningPhoton_t & photon)
			{pos=photon.pos;lastpos=photon.lastpos;c=photon.c;return *this;};
		const color_t & color() {return c;};
		void color(const color_t &col) {c=col;};
	protected:
		point3d_t pos;
		point3d_t lastpos;
		color_t c;
};

class globalPhotonMap_t;

class storedPhoton_t
{
	friend class globalPhotonMap_t;
	public:
		storedPhoton_t():dir(0.0,0.0,0.0) {};
		storedPhoton_t(const vector3d_t &d,const point3d_t &p,
				const color_t &col)
		{dir=d;pos=p;c=col;};
		storedPhoton_t(const runningPhoton_t &p/*,const vector3d_t &n*/)
		{pos=p.pos;c=p.c;dir=p.lastpos-p.pos;dir.normalize();/*N=n;*/};
		//storedPhoton_t(const storedPhoton_t &p)
		//{pos=p.pos;c=p.c;dir=p.dir;N=p.N;irr=p.irr;};
		const point3d_t & position()const {return pos;};
		//const storedPhoton_t & operator = ( const storedPhoton_t & photon)
		//	{pos=photon.pos;c=photon.c;dir=photon.dir;return *this;};
		const color_t & color()const {return c;};
		//const color_t & irradiance()const {return irr;};
		void color(const color_t &col) {c=col;};
		//void irradiance(const color_t &col) {irr=col;};
		const vector3d_t & direction()const {return dir;};
		void direction(const vector3d_t &d) {dir=d;};
		//const vector3d_t & normal()const {return N;};
		//void normal(const vector3d_t &d) {N=d;};
	protected:
		vector3d_t dir/*,N*/;
		point3d_t pos;
		color_t c/*,irr*/;
};

struct foundPhoton_t
{
	const storedPhoton_t *photon;
	PFLOAT dis;
};


class globalPhotonMap_t
{
	public:

		typedef std::vector<storedPhoton_t>::iterator iterator;
		typedef std::vector<storedPhoton_t>::const_iterator const_iterator;
		
		globalPhotonMap_t(PFLOAT r):maxradius(r),
			tree(NULL) {};
		~globalPhotonMap_t() {if(tree) delete tree;};

		//void store(const runningPhoton_t &p,const vector3d_t &N);
		void store(const storedPhoton_t &p);
		void buildTree();

		void gather(const point3d_t &P,const vector3d_t &N,
				std::vector<foundPhoton_t> &found,
				unsigned int K,PFLOAT &radius,PFLOAT mincos=0.0)const;

		int count()const {return photons.size();};
		PFLOAT getMaxRadius()const {return maxradius;};

		iterator begin() {return photons.begin();}; 
		const_iterator begin()const {return photons.begin();}; 
		iterator end() {return photons.end();}; 
		const_iterator end()const {return photons.end();}; 

	protected:
		PFLOAT maxradius;
		//hash3d_t<storedPhoton_t> hash;
		std::vector<storedPhoton_t> photons;
		gBoundTreeNode_t<const storedPhoton_t *> *tree;
};


__END_YAFRAY

#endif
