#!perl -w
#
# CcwDev -- the probed values for a Ccw device, as found in /sys.
#   Copyright (C) 2005  Erik van Konijnenburg
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
#
#
# The CCW devices are used in S390 architecture, and matched using
# a table similar to that for USB and PCI.
#
use strict;
use warnings;
use Base;
package CcwDev;
use base 'Obj';


sub fill {
	my $self = shift;
	$self->SUPER::fill();
	$self->takeArgs ('path');
	my $path = $self->{path};

	# these contain "%04x/%02x", type, model.
	my $cu = Base::getStringFile ("$path/cutype");
	my $dev = Base::getStringFile ("$path/devtype");

	if ($cu =~ m!^([[:xdigit:]]{4})/([[:xdigit:]]{2})$!) {
		$self->{cu_type} = hex ($1);
		$self->{cu_model} = hex ($2);
	}
	else {
		Base::fatal ("bad content of $path/cutype");
	}

	if ($dev =~ m!^([[:xdigit:]]{4})/([[:xdigit:]]{2})$!) {
		$self->{dev_type} = hex ($1);
		$self->{dev_model} = hex ($2);
	}
	else {
		Base::fatal ("bad content of $path/devtype");
	}

}

sub cu_type		{ return $_[0]->{cu_type}; }
sub cu_model		{ return $_[0]->{cu_model}; }
sub dev_type		{ return $_[0]->{dev_type}; }
sub dev_model		{ return $_[0]->{dev_model}; }

1;
