/***********************************************************************

RADIUS
Remote Authentication Dial In User Service

Lucent Technologies Remote Access
4464 Willow Road
Pleasanton, CA   94588

Copyright 1992-1999 Lucent Technologies Inc.  All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are
met:

   * Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.

   * Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.

   * All advertising materials mentioning features or use of this
     software must display the following acknowledgement:

	  This product includes software developed by Lucent
	  Technologies and its contributors.

   * Neither the name of the copyright holder nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

This software is provided by the copyright holders and contributors
``as is'' and any express or implied warranties, including, but not
limited to, the implied warranties of merchantability and fitness for a
particular purpose are disclaimed. In no event shall the copyright
holder or contributors be liable for any direct, indirect, incidental,
special, exemplary, or consequential damages (including, but not
limited to, procurement of substitute goods or services; loss of use,
data, or profits; or business interruption) however caused and on any
theory of liability, whether in contract, strict liability, or tort
(including negligence or otherwise) arising in any way out of the use
of this software, even if advised of the possibility of such damage.

************************************************************************/

/*
 * Copyright (C) 1999 Francesco P. Lovergine. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, and the entire permission notice in its entirety,
 *    including the disclaimer of warranties.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior
 *    written permission.
 * 4. Any modification to the program, as well as redistribution in binary
 *    or derived source form must be advertised to the author.
 *
 * THIS SOFTWARE IS PROVIDED `AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

static char rcsid[] = "$Id: pass.c,v 1.3 2001/02/24 11:38:37 kiavik Exp $";

#include "yard.h"
#include "global.h"

struct passwd	pw;
char	pwbuf[MAX_LINE_SIZE];

/*************************************************************************
 *
 *	Function: unix_pass
 *
 *	Purpose: Check the users password against the standard UNIX
 *		 password table.
 *
 *************************************************************************/

int unix_pass(char*name,char*passwd,char*from)
{
	struct passwd	*pwd;
	char		*encpw;
	char		*encrypted_pass;
	char		*crypt();
#if defined(SHADOW_PASSWORD)
#if defined(HAVE_GETSPNAM)
	struct spwd	*spwd;
#endif 
#endif 

	/* Get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			__debug("unix_pass: getownpwnam for \"%s\"%s failed\n", 
				name, from);
			return(-1);
		}
		encrypted_pass = pwd->pw_passwd;
	}
	else {
	/* Get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			__debug("unix_pass: getpwnam for \"%s\"%s failed\n",
				name, from);
			return(-1);
		}

#if defined(BSD4_4)
		/* Return failed if Unix Account is expired (locked out) */
		if (pwd->pw_expire && (pwd->pw_expire < time((time_t *)NULL))) {
			__debug("unix_pass: account for \"%s\"%s"
			        " has expired\n",name, from);
			return(-1);
		}
#endif
		encrypted_pass = pwd->pw_passwd;

#if defined(SHADOW_PASSWORD)
		if(strcmp(pwd->pw_passwd, "x") == 0 ||
		   strcmp(pwd->pw_passwd, "*") == 0 ||
		   strcmp(pwd->pw_passwd, "*NP*") == 0) {
#if defined(HAVE_GETSPNAM)
		   if((spwd = getspnam(name)) == NULL) { return(-1); }
		   encrypted_pass = spwd->sp_pwdp;
		}
#endif
#endif
	}

	/* Run encryption algorythm */
	encpw = crypt(passwd, encrypted_pass);

	/* Check it */
	if(strcmp(encpw, encrypted_pass)) {
		__debug("unix_pass: password for \"%s\"%s failed\n", name, from);
		return(-1);
	}
	return(0);
}

/*************************************************************************
 *
 *	Function: unix_group
 *
 *	Purpose: Check the user's membership to the standard UNIX
 *		 group table.
 *
 *************************************************************************/

int unix_group(const char*name,const char*group)
{
	struct passwd	*pwd;
	char		**gr_mem;
	struct group	*gr_ent;
	
	/* Get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			__debug("unix_group: getownpwnam for \"%s\" failed\n", name);
			return(-1);
		}
	} else {
	/* Get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			__debug("unix_group: getpwnam for \"%s\" failed\n", name);
			return(0);
		}
	}

	if((gr_ent = getgrnam(group)) == NULL) {
		__debug("unix_group: getgrnam(%s) for \"%s\" failed\n", group,name);
		return(0);
	}

	/* Check the immediate group */
	if(pwd->pw_gid == gr_ent->gr_gid) {
		return(1);
	}
	/* Search for this user */
	gr_mem = gr_ent->gr_mem;
	while(*gr_mem != NULL) {
		if(strcmp(*gr_mem, name) == 0) {
			return(1);
		}
		gr_mem++;
	}
	return(0);
}


/*************************************************************************
 *
 *	Function: unix_gecos
 *
 *	Purpose: Get the user's GECOS field or "" if it is empty.
 *
 *************************************************************************/

char *unix_gecos(const char*name)
{
	struct passwd	*pwd;
	
	/* get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			__debug("unix_gecos: getownpwnam for \"%s\" failed\n", name);
			return "";
		}
	} else {
	/* get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			__debug("unix_gecos: getpwnam for \"%s\" failed\n", name);
			return "";
		}
	}

	return pwd->pw_gecos;
}


/*************************************************************************
 *
 *	Function: unix_shell
 *
 *	Purpose: Get the user's shell or "" if it is empty.
 *
 *************************************************************************/

char *unix_shell(const char*name)
{
	struct passwd	*pwd;
	
	/* get encrypted password from alternate password file */
	if (alt_passwd != (char *)NULL) {
		if((pwd = getownpwnam(name)) == NULL) {
			__debug("unix_gecos: getownpwnam for \"%s\" failed\n", name);
			return "";
		}
	} else {
	/* get encrypted password from password file */
		if((pwd = getpwnam(name)) == NULL) {
			__debug("unix_gecos: getpwnam for \"%s\" failed\n", name);
			return "";
		}
	}

	return pwd->pw_shell;
}

struct passwd *getownpwnam(const char*name)
{
	extern char	*alt_passwd;
	extern char	pwbuf[];
	extern struct passwd	pw;
	FILE		*pwfd;
	char		*ptr;

	if (alt_passwd == (char *)NULL) {
		return (struct passwd *)NULL;
	}
	if((pwfd = fopen(alt_passwd, "r")) == (FILE *)NULL) {
		return (struct passwd *)NULL;
        }

	memset((char *)&pw,0,sizeof(pw));
	while(fgets(pwbuf, MAX_LINE_SIZE, pwfd) != (char *)NULL) {
		ptr = pwbuf;
		while (*ptr && *ptr != ':')
			ptr++;
		*ptr++ = '\0';
		if (strcmp(name,pwbuf) == 0) {
			pw.pw_name = pwbuf;
			pw.pw_passwd = ptr;
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_uid = atoi(ptr);
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_gid = atoi(ptr);
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_gecos = ptr;
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_dir = ptr;
			while (*ptr && *ptr != ':')
				ptr++;
			*ptr++ = '\0';
			pw.pw_shell = ptr;

			return (&pw);
		}
	}
	return (struct passwd *)NULL;
}
