/*
  Copyright (C) 2005, 2006, 2007, 2008 Tadashi Watanabe <wac@umiushi.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */




#include "skk_gcc.hpp"




int local_main(int argc,
               char *argv[]);




#ifdef SKK_DEBUG_NEW


static void skk_debug_new_check_leak()
{
        DEBUG_PRINTF("skk_debug_new_check_leak()  skk_debug_new_total_size:%d\n",
                     skk_debug_new_total_size);
        for (int i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p)
                {
                        DEBUG_PRINTF("leak:%p  size:%d  %s:%d\n",
                                     skk_debug_new_buffer[i].p,
                                     skk_debug_new_buffer[i].size,
                                     skk_debug_new_buffer[i].filename,
                                     skk_debug_new_buffer[i].line);
                }
        }
}


#endif  // SKK_DEBUG_NEW




static void signal_dictionary_update_handler(int signum)
{
        signum = 0;             // KILLWARNING
}




int main(int argc,
         char *argv[])
{
        signal(SIGHUP,
               signal_dictionary_update_handler);

        int result = local_main(argc,
                                argv);

#ifdef SKK_DEBUG_NEW
        skk_debug_new_check_leak();
#endif  // SKK_DEBUG_NEW

        return result;
}




#ifdef YASKKSERV_DEBUG




// skk_gcc.hpp Ƥޥ
#undef new
#undef delete




void Debug::printf_core(const char *filename,
                        int line,
                        const char *p,
                        ...)
{
        char buffer[16 * 1024];

        va_list ap;

        va_start(ap,
                 p);

        vsnprintf(buffer,
                  sizeof(buffer),
                  p,
                  ap);

        va_end(ap);

        FILE *file;
        time_t time_object;
        char tmp_buffer[1024];

        file = fopen("/tmp/yaskkserv.debuglog.tmp",
                     "a");
        time_object = time(0);

        tmp_buffer[0] = '[';
        strcpy(&tmp_buffer[1],
               ctime(&time_object));

        for (int i = 0; i != 1024 - 8; ++i)
        {
                if (tmp_buffer[i] == '\0')
                {
                        break;
                }
                if (tmp_buffer[i] == '\n')
                {
                        tmp_buffer[i + 0] = ']';
                        tmp_buffer[i + 1] = ':';
                        tmp_buffer[i + 2] = '\0';
                        fputs(tmp_buffer,
                              file);
                        break;
                }
        }
        fprintf(file,
                "%s:%d ",
                filename,
                line);
        fputs(buffer,
              file);
        fclose(file);
}




void Debug::print_core(const char *filename,
                       int line,
                       const char *p)
{
        FILE *file;
        time_t time_object;
        char tmp_buffer[1024];

        file = fopen("/tmp/yaskkserv.debuglog.tmp",
                     "a");
        time_object = time(0);

        tmp_buffer[0] = '[';
        strcpy(&tmp_buffer[1],
               ctime(&time_object));

        for (int i = 0; i != 1024 - 8; ++i)
        {
                if (tmp_buffer[i] == '\0')
                {
                        break;
                }
                if (tmp_buffer[i] == '\n')
                {
                        tmp_buffer[i + 0] = ']';
                        tmp_buffer[i + 1] = ':';
                        tmp_buffer[i + 2] = '\0';
                        fputs(tmp_buffer,
                              file);
                        break;
                }
        }
        fprintf(file,
                "%s:%d ",
                filename,
                line);
        fputs(p,
              file);
        fclose(file);
}




#endif  // YASKKSERV_DEBUG




#ifdef SKK_DEBUG_NEW




size_t skk_debug_new_total_size = 0;
bool skk_debug_new_first_flag = true;
skk_debug_new_t skk_debug_new_buffer[SKK_DEBUG_NEW_BUFFER_LENGTH];




void skk_debug_new_initialize_first()
{
        for (int i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                skk_debug_new_buffer[i].p = 0;
                skk_debug_new_buffer[i].size = 0;
                skk_debug_new_buffer[i].filename[0] = '\0';
                skk_debug_new_buffer[i].line = 0;
        }
        skk_debug_new_first_flag = false;
}




void *operator new(size_t size)
{
        if (skk_debug_new_first_flag)
        {
                skk_debug_new_initialize_first();
        }

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == 0)
                {
                        goto FOUND;
                }
        }


        DEBUG_ASSERT(0);


FOUND:
        skk_debug_new_total_size += size;

        void *p;

        p = malloc(size);
        skk_debug_new_buffer[i].p = p;
        skk_debug_new_buffer[i].size = size;
        strcpy(skk_debug_new_buffer[i].filename,
               "-");
        skk_debug_new_buffer[i].line = 0;

        DEBUG_PRINTF("DEBUG      new:%d  total:%d  p:%p  id:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i);

        return p;
}




void *operator new(size_t size,
                   const char *filename,
                   int line)
{
        if (skk_debug_new_first_flag)
        {
                skk_debug_new_initialize_first();
        }

        DEBUG_PRINTF("filename:%s:%d\n",
                     filename,
                     line);

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == 0)
                {
                        goto FOUND;
                }
        }


        DEBUG_ASSERT(0);


FOUND:
        skk_debug_new_total_size += size;

        void *p;

        p = malloc(size);
        skk_debug_new_buffer[i].p = p;
        skk_debug_new_buffer[i].size = size;
        strcpy(skk_debug_new_buffer[i].filename,
               filename);
        skk_debug_new_buffer[i].line = line;

        DEBUG_PRINTF("DEBUG      new:%d  total:%d  p:%p  id:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i);

        return p;
}




void operator delete(void *p)
{
        if (p == 0)
        {
                DEBUG_PRINTF("DEBUG   delete null\n");
                return;
        }

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == p)
                {
                        goto FOUND;
                }
        }


        DEBUG_ASSERT(0);


FOUND:
        size_t size;

        size = skk_debug_new_buffer[i].size;
        skk_debug_new_total_size -= size;

        DEBUG_PRINTF("DEBUG   delete:%d  total:%d  p:%p  id:%d  filename:%s:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i,
                     skk_debug_new_buffer[i].filename,
                     skk_debug_new_buffer[i].line);

        skk_debug_new_buffer[i].p = 0;
        skk_debug_new_buffer[i].size = 0;
        skk_debug_new_buffer[i].filename[0] = '\0';
        skk_debug_new_buffer[i].line = 0;

        free(p);
}




void *operator new[](size_t size)
{
        if (skk_debug_new_first_flag)
        {
                skk_debug_new_initialize_first();
        }

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == 0)
                {
                        goto FOUND;
                }
        }


        DEBUG_ASSERT(0);


FOUND:
        skk_debug_new_total_size += size;

        void *p;

        p = malloc(size);
        skk_debug_new_buffer[i].p = p;
        skk_debug_new_buffer[i].size = size;
        strcpy(skk_debug_new_buffer[i].filename,
               "-");
        skk_debug_new_buffer[i].line = 0;
        DEBUG_PRINTF("DEBUG    new[]:%d  total:%d  p:%p  id:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i);
        return p;
}




void *operator new[](size_t size,
                     const char *filename,
                     int line)
{
        if (skk_debug_new_first_flag)
        {
                skk_debug_new_initialize_first();
        }

        DEBUG_PRINTF("filename:%s:%d\n",
                     filename,
                     line);

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == 0)
                {
                        goto FOUND;
                }
        }


        DEBUG_ASSERT(0);


FOUND:
        skk_debug_new_total_size += size;

        void *p;

        p = malloc(size);
        skk_debug_new_buffer[i].p = p;
        skk_debug_new_buffer[i].size = size;
        strcpy(skk_debug_new_buffer[i].filename,
               filename);
        skk_debug_new_buffer[i].line = line;

        DEBUG_PRINTF("DEBUG    new[]:%d  total:%d  p:%p  id:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i);

        return p;
}




void operator delete[](void *p)
{
        if (p == 0)
        {
                DEBUG_PRINTF("DEBUG   delete[] null\n");
                return;
        }

        int i;
        for (i = 0; i != SKK_DEBUG_NEW_BUFFER_LENGTH; ++i)
        {
                if (skk_debug_new_buffer[i].p == p)
                {
                        goto FOUND;
                }
        }


        DEBUG_PRINTF("DEBUG delete[] %p not found\n",
                     p);
        DEBUG_ASSERT(0);


FOUND:
        size_t size;

        size = skk_debug_new_buffer[i].size;
        skk_debug_new_total_size -= size;

        DEBUG_PRINTF("DEBUG   delete:%d  total:%d  p:%p  id:%d  filename:%s:%d\n",
                     size,
                     skk_debug_new_total_size,
                     p,
                     i,
                     skk_debug_new_buffer[i].filename,
                     skk_debug_new_buffer[i].line);

        skk_debug_new_buffer[i].p = 0;
        skk_debug_new_buffer[i].size = 0;
        skk_debug_new_buffer[i].filename[0] = '\0';
        skk_debug_new_buffer[i].line = 0;

        free(p);
}




#endif  // SKK_DEBUG_NEW
