/**
 * yateaddressbookview.cpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "yateaddressbookview.hpp"
#include "yateaddressbookview.moc"
#include "yateaddressbook.hpp"

#include <qlistview.h>
#include <qframe.h>

YABVItem::YABVItem (QListView *lv, YateAddress *add) :
	QListViewItem (lv, add->getAlias()),
	address (add)
{
	qDebug ("Added %s", add->getAlias());
}

YABVItem::~YABVItem ()
{
}

YateAddressBookView::YateAddressBookView (QWidget *parent, YateAddressBook *ab) :
	QWidget (parent),
	addressbook (ab)
{
	setFixedSize (160, 180);

	lvContacts = new QListView (this);
	lvContacts->setGeometry (0, 0, 160, 180);
	lvContacts->addColumn ("Contacts");
	lvContacts->setColumnWidth(0, 156);
	lvContacts->setColumnWidthMode(0, QListView::Maximum);
	lvContacts->setFrameStyle (QFrame::Panel + QFrame::Sunken);

	rescanAddressBook();

	connect (lvContacts, SIGNAL (doubleClicked(QListViewItem *)),
		 this, SLOT (doubleClickedContact (QListViewItem *)));
}

YateAddressBookView::~YateAddressBookView()
{
}

void YateAddressBookView::doubleClickedContact (QListViewItem *item)
{
	emit dialRequest (((YABVItem *)item)->getAddress()->getAddress());
}

void YateAddressBookView::rescanAddressBook (void)
{
	unsigned int n = addressbook->getNContacts();
	lvContacts->clear();
	for (unsigned int i=0; i<n; i++) {
		if (addressbook->getContact (i)) {
			new YABVItem (lvContacts, addressbook->getContact(i));
		}
	}
}
