/**
 * yateaddressinput.cpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "yateaddressinput.hpp"
#include "yateaddressinput.moc"

#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>

YateAddressInput::YateAddressInput (QWidget *parent, const char *initialNumber) :
	QDialog (parent, "Add to AddressBook")
{
	setFixedSize (300, 110);
	setCaption ("Add to AddressBook");
	labelAlias = new QLabel (this);
	labelAlias->setGeometry (10, 10, 70, 27);
	labelAlias->setAlignment(AlignRight);
	labelAlias->setText ("Alias:");

	labelAddress = new QLabel (this);
	labelAddress->setGeometry (10, 40, 70, 27);
	labelAddress->setAlignment(AlignRight);
	labelAddress->setText ("Address:");

	leAlias = new QLineEdit (this);
	leAlias->setGeometry (80, 10, 215, 27);
	leAlias->setText ("Alias");
	leAlias->selectAll();

	leAddress = new QLineEdit (this);
	leAddress->setGeometry (80, 40, 215, 27);
	leAddress->setText (initialNumber ? initialNumber : "");

	pbAccept = new QPushButton (this);
	pbAccept->setGeometry (100, 70, 95, 30);
	pbAccept->setText ("&Accept");

	pbCancel = new QPushButton (this);
	pbCancel->setGeometry (200, 70, 95, 30);
	pbCancel->setText ("&Cancel");

	connect (pbAccept, SIGNAL (clicked()), this, SLOT(accept()));
	connect (pbCancel, SIGNAL (clicked()), this, SLOT(reject()));
}

YateAddressInput::~YateAddressInput()
{
	delete labelAlias; labelAlias = NULL;
	delete labelAddress; labelAddress = NULL;
	delete leAlias; leAlias = NULL;
	delete leAddress; leAddress = NULL;
	delete pbAccept; pbAccept = NULL;
	delete pbCancel; pbCancel = NULL;
}

const char *YateAddressInput::getAddress(void)
{
	return leAddress->text().latin1();
}

const char *YateAddressInput::getAlias (void)
{
	return leAlias->text().latin1();
}
