/**
 * yatenumberdisplay.cpp
 * This file is part of the YATE Project http://YATE.null.ro
 *
 * A Qt based universal telephony client
 * Author: Dorin Lazar <lazar@deuromedia.ro>
 *
 * Yet Another Telephony Engine - a fully featured software PBX and IVR
 * Copyright (C) 2004 Null Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "yatenumberdisplay.hpp"
#include "yatenumberdisplay.moc"

#include <qlineedit.h>

YateNumberDisplay::YateNumberDisplay(QWidget *parent) :
	QComboBox(parent, NULL)
{
	setEditable (true);
	number = QString ("");
	lineEdit()->setText ("");
	setFixedSize (200, 25);
	connect (lineEdit(), SIGNAL(textChanged(const QString&)), this, SLOT(setNumber(const QString&)));
}

YateNumberDisplay::~YateNumberDisplay()
{
	
}

void YateNumberDisplay::addDigit (char c)
{
	number += QChar(c);
	lineEdit()->setText (number);
}

void YateNumberDisplay::removeLastDigit (void)
{
	unsigned int n = number.length();
	number.remove (n-1, 1);
	lineEdit()->setText (number);
}

void YateNumberDisplay::setNumber (const char *newNumber)
{
	number = QString(newNumber);
	lineEdit()->setText (number);
}

void YateNumberDisplay::setNumber (const QString& newNumber)
{
	//setNumber (newNumber.latin1());
	number = newNumber;
}

void YateNumberDisplay::setReadOnly (bool ro)
{
	lineEdit()->setReadOnly (ro);
}

void YateNumberDisplay::setHistoryItems (QStringList& strlist)
{
	QString oldnum = number;
	clear();
	insertStringList (strlist);
	setCurrentText (oldnum);
}
