/* This is for emacs: -*-Mode: C++;-*- */
/*  
  Copyright 2002, Andreas Rottmann

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/
#if !defined(__INC_PYTHON_SCRIPT_H)
#define __INC_PYTHON_SCRIPT_H

#include <glib.h>

#include <string>

#include <Python.h>

#include <yehia/script/base.h>

namespace Yehia
{

namespace Script
{

class pythonObject;

class pythonObjectFactory : public ObjectFactory
{
  public:
    pythonObjectFactory();
    virtual ~pythonObjectFactory();
    
    virtual Object& create_value(const Any& v);
    virtual Object& create_genfunc();
    virtual Object& create_class(const Signature& supers);
    virtual Object& wrap_instance(const Object& klass, SigC::Object& obj);
    virtual Object& create_namespace();

    virtual Object& null_object();
    
    pythonObject& create_object(PyObject *pyobj);

    PyObject *to_pyobj(const Any& v); 
    Object *call_pyobj(const ParamList& args, PyObject *callable);
    Any pyobj_to_any(PyObject *pyobj);

    void register_instance(SigC::Object *cppinst, PyObject *pyinst) {
      g_hash_table_insert(instance_hash_, cppinst, pyinst);
    }
    void unregister_instance(SigC::Object *cppinst) {
      g_hash_table_remove(instance_hash_, cppinst);
    }
  private:
    virtual void destroy(Object& obj);
    
    GMemChunk *memchunk_;
    pythonObject *null_obj_;
    pythonObject *sigc_obj_class_;
    GHashTable *instance_hash_;
};

class pythonObject : public Object,
                     protected Instance, protected Namespace, 
                     protected GenFunc, protected Class
{
  public:
    pythonObject(pythonObjectFactory& factory, PyObject *pyobj = 0);
    virtual ~pythonObject();
    
    pythonObjectFactory& factory() const {
      return dynamic_cast<pythonObjectFactory&>(Script::Object::factory());
    }
    
    virtual Namespace *namespace_interface();
    virtual Instance *instance_interface();
    virtual Function *function_interface();
    virtual GenFunc *genfunc_interface();
    virtual Class *class_interface();
    
    // Value
    virtual Any value() const;
    
    // Instance interface
    virtual SigC::Object& object();
    Script::Object& class_object();

    // Namespace interface
    virtual Script::Object *member(const std::string& name);
    virtual void insert(const std::string& name, Script::Object& object);
    
    // GenericFunction interface
    virtual void add_method(const Slot& slot, const Signature& sig);
    virtual Script::Object *call(const ParamList& args);
    
    // Class interface
    virtual void set_constructor(Object& genfunc);
    virtual void add_genfunc(const std::string& name, Object& genfunc);
    virtual void add_class_genfunc(const std::string& name, Object& genfunc);
    virtual void add_setter(const std::string& name, Object& genfunc);
    virtual void add_getter(const std::string& name, Object& genfunc);
    
    // Utilities
    void ensure(bool cond);
    bool is_null();
    pythonObject& operator=(PyObject *pyobj);
    PyObject *pyobj() const;
  private:
    PyObject *pyobj_;
};

}

}

#endif
