/**************************************************************************************************
	$Header: /pub/cvsroot/yencode/src/y.h,v 1.19 2002/03/15 14:48:52 bboy Exp $

	Copyright (C) 2002  Don Moore <bboy@bboy.net>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at Your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
**************************************************************************************************/

#ifndef _Y_H
#define _Y_H

#include <stdio.h>
#include <config.h>
#include <misc.h>
#include <dirent.h>

#if HAVE_INTTYPES_H
#	include <inttypes.h>
#endif
#if HAVE_UNISTD_H
#	include <unistd.h>
#endif
#if HAVE_STDARG_H
#	include <stdarg.h>
#endif
#ifdef HAVE_GETOPT_H
#	include <getopt.h>
#else
#	include "getopt.h"
#endif
#if HAVE_TIME_H
#	include <time.h>
#endif
#if HAVE_SYS_TIME_H
#	include <sys/time.h>
#endif

#include "crc.h"
#include "output.h"
#include "support.h"
#include "file.h"


/* Default file extension */
#ifndef	Y_EXT
#	define Y_EXT "ync"
#endif

/* Default line length */
#ifndef	Y_LL
#	define Y_LL 128
#endif

/* Default system type */
#ifndef	SYSTYPE
#	define SYSTYPE NULL
#endif

/* Do the +42 `encoding' against char `c' */
#define	YENCODE(c) 			((c + 42) & 255)

/* Do the -42 `decoding' against char `c' */
#define	YDECODE(c) 			((c - 42) & 255)


/* Nonzero if we MUST encode char `c' at any position */
#define	YMUST_ESCAPE(c)			(c == '\0' || c == '\r' || c == '\n' || c == '=')

/* Nonzero if we MUST encode if this is the first character of a line */
#define	YESCAPE_IF_FIRST(c)		(c == '\t' || c == '.' || c == ' ')

/* Nonzero if we MUST encode if this is the last character of a line */
#define	YESCAPE_IF_LAST(c)		(c == '\t' || c == ' ')

/* Nonzero if it makes sense to encode this character at least SOMETIMES */
#define	YESCAPE_MAKES_SENSE(c)	(c == '\0' || c == '\r' || c == '\n' || c == '=' || c == '\t' || c == ' ' || c == '.')

/* Determines if a character needs to be escaped taking into account the offset within the current line
	and the maximum line length */
#define	YSHOULD_ESCAPE(c,o,l)	(YMUST_ESCAPE(c) || (o == 0 && YESCAPE_IF_FIRST(c)) || (o+1 >= l && YESCAPE_IF_LAST(c)))


/* Nonzero if buffer `b' starts with "=y" */
#define	YKEYWORD(b)			(b[0] == '=' && b[1] == 'y')

/* Nonzero if buffer `b' starts with "=ybegin" */
#define	YKEYWORD_BEGIN(b)	(YKEYWORD(b) && b[2] == 'b' && b[3] == 'e' && b[4] == 'g' && b[5] == 'i' && b[6] == 'n')

/* Nonzero if buffer `b' starts with "=ypart" */
#define	YKEYWORD_PART(b)	(YKEYWORD(b) && b[2] == 'p' && b[3] == 'a' && b[4] == 'r' && b[5] == 't')

/* Nonzero if buffer `b' starts with "=yend" */
#define	YKEYWORD_END(b)	(YKEYWORD(b) && b[2] == 'e' && b[3] == 'n' && b[4] == 'd')


/* Evaluates as the proper escape character for `c' */
#define	YESCAPE(c)			((c + 64) & 255)
#define	YUNESCAPE(c)		((c - 64) & 255)


#endif /* !_Y_H */

/* vi:set ts=3: */
