/*
 * YH - Console Chinese Environment -
 * Copyright (C) 1999 Red Flag Linux (office@sonata.iscas.ac.cn)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY TAKASHI MANABE ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE TERRENCE R. LAMBERT BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */


/*****************---main.c----*********************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <termio.h>

#ifdef OPENSERVER
#include <sys/console.h>
#else
#include <sys/kd.h>
#endif

#include <time.h>
#include "display.h"
#include "chncon.h"

#ifdef linux
#include <vga.h>
#include <linux/keyboard.h>	/*KEYMAP*/
#include <linux/limits.h>
#endif

#ifdef linux
#include <vgakeyboard.h>	/*SCANCODE*/
#endif

int	fdVGA;
pid_t	pidWrite = 0;
pid_t	pidRead = 0;
pid_t	pidShell = 0;
pid_t	pidListen = 0;
int	fdm;
int	pipeCom[2];
int	pipePrompt[2];
char	mylicense[LICENSE_SIZE];
char	lockfilename[] = "/tmp/yh.lock";
char	yhexec[256];

static int		disptype, dispmode;
static struct termios	termio;/*struct termio -> struct termios*/
static struct winsize	winsize;
static char		portfilename[64];

static void	catch_exception();
static void	SaveTtyStat();
static void	RestoreTtyStat();
static void	SetTtyRaw();
static void	LoadIM();
static void	ExecShell(char *argv0);
static void	DisplayTitle();
static void 	CheckDate();
#ifdef linux
static void setkeymap(void);
static void savekeymap(void);
static void restorekeymap(void);
#endif


int	main(argc, argv)
int	argc;
char	*argv[];
{
	char			*p;
	int			count;
	char			ptypbuf[16], ttypbuf[16];
	int			rv, port;
	int			mask;
	FILE			*pf;
	struct sigaction	act;
	char			s[128];
        int			i;
#ifdef GEMINI
	if (access(lockfilename, F_OK) == 0)
	{
		puts("Another YanHuang is already running.");
		return;
	}
	pf = fopen(lockfilename, "wt");
	fclose(pf);
#endif
	sprintf(s, "%s/.yhexec", getenv("HOME"));
	pf = fopen(s, "r");
	if (pf != NULL)
	{
		fscanf(pf, "%s", yhexec);
		fclose(pf);
	}
	else
		yhexec[0] = '\0';
	fdVGA = 0;
#ifdef linux		
	{
		char str[80];
		int flag;
		FILE *fp;

		flag=0;
		fp=fopen("/etc/bashrc","r");
		while(!feof(fp))
		{
			fscanf(fp,"%s",str);
			if(!strcmp(str,"alias ls='ls --color'"))
			{ 
			  flag=1;
			  break;
			}
		}
		fclose(fp);
		if(!flag)
		{
			fp=fopen("/etc/bashrc","a+");
			fprintf(fp,"alias ls='ls --color'\n");
			fclose(fp);
		}	
	}
#endif	

#ifdef STONE_OEM
	if (access("/etc/perms/mup", F_OK) != 0)
	{
		puts("This version of YanHuang Chinese Platform needs"
			" STONE MultiVideo.");
		exit(0);
	}
#endif

	/*
	 * Check license
	 */
#if 1
	strcpy(mylicense, "ABC123");
#else
	if ((p = chkserkey()) == NULL)
		exit(0);
	strcpy(mylicense, p);
#endif

	/*
	 * Make sure we have a VGA
	 */
        if (0== vga_hasmode(4))
        {
		puts("A VGA display adapter is required.");
		rv = -1;
		exit(1);
	}
        dispmode=vga_getcurrentmode();

	SaveTtyStat();

	/*
	 * Catch signals
	 */
	act.sa_flags = 0;
	memset(&act.sa_mask, 0, sizeof(act.sa_mask));

	for (count = SIGHUP; count <= SIGPROF; count++)
		if (count != SIGCLD)
		{
			act.sa_handler = catch_exception;
#if (defined(OPENSERVER) || defined(GEMINI))
			act.sa_sigaction = catch_exception;
#endif
			sigaction(count, &act, NULL);
		}

	/*
	 * Parse command line
	 */
	if ((argc == 2) && (memcmp(argv[1], "-m", 2) == 0))
	{
		mono = atoi(&argv[1][2]);
		if (mono == 0)
			mono = 7;
	}

	/*
	 * Get a pesudo tty
	 */
	for (count = 0; count < 64; count++)
	{
		sprintf(ptypbuf, "/dev/ptyp%d", count);
		sprintf(ttypbuf, "/dev/ttyp%d", count);
		if ((fdm = open(ptypbuf,O_RDWR)) > 0)
		{
			int	fds;

			fds = open(ttypbuf, O_RDWR);
			if (fds > 0)
			{
				close(fds);
				break;
			}
		}
	}

	if (fdm <= 0)
	{
		puts("Can't get a pesudo tty.");
		exit(1);
	}

	/*
	 * Create the communication pipes
	 */
	pipe(pipeCom);
	pipe(pipePrompt);

	/*
	 * Start process pidWrite
	 */
	if ((pidWrite = fork()) == 0)
	{
		close(pipeCom[0]);
		close(pipePrompt[1]);
		WriteScr(); /* never return */
	}

	/*
	 * Wait process pidWrite initliazing display and listening license
	 */
	read(pipeCom[0], &rv, sizeof(rv));
	if (rv < 0)
		exit(1);
	read(pipeCom[0], &pidListen, sizeof(pidListen));

	/*
	 * Start process pidRead
	 */
	if ((pidRead = fork()) == 0)
	{
		close(pipeCom[0]);
		close(pipePrompt[0]);
		close(1);
		close(2);
		SetTtyRaw();
		ReadKeybrd();	/* never return */
	}

	/*
	 * Wait process pidRead listening
	 */
	read(pipeCom[0], &port, sizeof(port));

	/*
	 * Save the port number
	 */
	mask = umask(0);
	mkdir("/tmp/dev", 0777);
	sprintf(portfilename, "/tmp%s", ttypbuf);
	pf = fopen(portfilename, "w");
	if (pf != NULL)
	{
		fprintf(pf, "%d\n%s\n", port, ttyname(0));
		fclose(pf);
	}
	umask(mask);

	/*
	 * Close all file decriptiors we doesn't need
	 */
	close(pipePrompt[0]);
	close(pipePrompt[1]);
	close(pipeCom[0]);
	close(pipeCom[1]);

	/*
	 * Start the process pidShell to load IMs, execute shell
	 */
	if ((pidShell = fork()) == 0)
	{
		int	fds;
		int	pid;

		/*
		 * Disassociate from our control terminal so we can acquire
		 * the pseudo-termianl slave as our control tty. This call
		 * also makes us a process group leader, which is necessary to
		 * acquire a control tty.
		 */
		for (i=3;i< OPEN_MAX;i++)
                   close(i);
                /*
		 * Open the pseudo-terminal slave and: 1. Set it as our
		 * control tty. 2. Set the inital mode
		 */
		setsid();
                pid = getpid();
		fds = open(ttypbuf, O_RDWR);
		ioctl(fds, TIOCSCTTY,0);
		ioctl(fds, TIOCSWINSZ, &winsize);
                seteuid(getuid());/*for security*/
		/*
		 * Redirect 0, 1, and 2
		 */
		dup2(fds, 0);
		dup2(fds, 1);
		dup2(fds, 2);
		close(fds);
		DisplayTitle();
		LoadIM();
		ExecShell(argv[0]);
	}

	/*
	 * Wait a child terminating
	 */
	wait(NULL);
	raise(SIGHUP);
}


static void	catch_exception()
{
	unlink(portfilename);
	unlink(lockfilename);

	if (pidShell != 0)
		kill(pidShell, SIGHUP);
	if (pidRead != 0)
		kill(pidRead, SIGHUP);
	if (pidWrite != 0)
		kill(pidWrite, SIGHUP);
	if (pidListen != 0)
		kill(pidListen, SIGTERM);

	RestoreTtyStat();

	exit(0);
}


static void	SaveTtyStat()
{
        tcgetattr(0,&termio);
	ioctl(0, TIOCGWINSZ, &winsize);
	#ifdef linux 
	savekeymap();
	#endif
}


static void	RestoreTtyStat()
{
        tcsetattr(0,TCSAFLUSH,&termio);
#ifndef linux  
	ioctl(0, MODESWITCH | dispmode, NULL);
#endif
	#ifdef linux 
	restorekeymap();
	#endif
}


static void	SetTtyRaw()
{
	struct	termios	tio;
        tcgetattr(0,&tio);
	tio.c_iflag = 0;
	tio.c_oflag &= ~OPOST;
	tio.c_lflag &= ~(ISIG | ICANON | ECHO | IEXTEN);
	tio.c_cflag &= ~(CSIZE | PARENB);
	tio.c_cflag |= CS8;
	tio.c_cc[VMIN] = 1;
	tio.c_cc[VTIME] = 1;
        tcsetattr(0,TCSAFLUSH,&tio);
        #ifdef linux
        setkeymap();
        #endif
}

#ifdef linux

#define CTRL_SPACE	200
#define SHIFT_F1	201
#define SHIFT_F2	202
#define SHIFT_F3	203
#define SHIFT_F4	204
#define SHIFT_F5	205
#define SHIFT_F6	206
#define SHIFT_F7	207
#define SHIFT_F8	208
#define CTRL_ALT_b	209
#define CTRL_ALT_g	210


static void setkeymap(void)  
{  
   struct kbentry KEYMAP;  
   int i;
   
   KEYMAP.kb_table=1<<KG_CTRL;
   KEYMAP.kb_index=SCANCODE_SPACE;
   KEYMAP.kb_value=K(KT_LATIN,CTRL_SPACE);
   ioctl(0,KDSKBENT,&KEYMAP);  

   KEYMAP.kb_table=1<<KG_SHIFT;
   for (i=0;i<8;i++)
   {
	KEYMAP.kb_index=SCANCODE_F1+i;
	KEYMAP.kb_value=K(KT_LATIN,SHIFT_F1+i);
	ioctl(0,KDSKBENT,&KEYMAP);
   }

   KEYMAP.kb_table=(1<<KG_CTRL)+(1<<KG_ALT);
   KEYMAP.kb_index=SCANCODE_B;
   KEYMAP.kb_value=K(KT_LATIN,CTRL_ALT_b);
   ioctl(0,KDSKBENT,&KEYMAP);

   KEYMAP.kb_index=SCANCODE_G;
   KEYMAP.kb_value=K(KT_LATIN,CTRL_ALT_g);
   ioctl(0,KDSKBENT,&KEYMAP);
}  


static unsigned int oldkeymap[20];
static void savekeymap()
{
   struct kbentry KEYMAP;
   int i;
   
   KEYMAP.kb_table=1<<KG_CTRL;
   KEYMAP.kb_index=SCANCODE_SPACE;
   ioctl(0,KDGKBENT,&KEYMAP);
   oldkeymap[0]=KEYMAP.kb_value;

   KEYMAP.kb_table=1<<KG_SHIFT;
   for (i=0;i<8;i++)
   {
	KEYMAP.kb_index=SCANCODE_F1+i;
        ioctl(0,KDGKBENT,&KEYMAP);
 	oldkeymap[i+1]=KEYMAP.kb_value;
   }

   KEYMAP.kb_table=(1<<KG_CTRL)+(1<<KG_SHIFT);
   KEYMAP.kb_index=SCANCODE_B;
   ioctl(0,KDGKBENT,&KEYMAP);
   oldkeymap[9]=KEYMAP.kb_value;

   KEYMAP.kb_index=SCANCODE_G;
   ioctl(0,KDGKBENT,&KEYMAP);
   oldkeymap[10]=KEYMAP.kb_value;
}


static void restorekeymap()
{
   struct kbentry KEYMAP;
   int i;

   KEYMAP.kb_table=1<<KG_CTRL;
   KEYMAP.kb_index=SCANCODE_SPACE;
   KEYMAP.kb_value=oldkeymap[0];
   ioctl(0,KDSKBENT,&KEYMAP);
   
   KEYMAP.kb_table=1<<KG_SHIFT;
   
   for(i=0;i<8;i++)
   {
	KEYMAP.kb_index=SCANCODE_F1+i;
  	KEYMAP.kb_value=oldkeymap[i+1];
	ioctl(0,KDSKBENT,&KEYMAP);
   }

   KEYMAP.kb_table=(1<<KG_CTRL)+(1<<KG_ALT);
   KEYMAP.kb_index=SCANCODE_B;
   KEYMAP.kb_value=oldkeymap[9];
   ioctl(0,KDSKBENT,&KEYMAP);

   KEYMAP.kb_index=SCANCODE_G;
   KEYMAP.kb_value=oldkeymap[10];
   ioctl(0,KDSKBENT,&KEYMAP);
}

#endif


static void	LoadIM()
{
	char	*p;
	char	s[256];
	char	imname[64];
	FILE	*pf;

	printf("\033[1m");

	sprintf(s, "%s/.ims", getenv("HOME"));
	if ((pf = fopen(s, "r")) == NULL)
	{
		if ((pf = fopen("/usr/local/yh/lib/system.ims", "r")) == NULL)
			return;
	}

	while (! feof(pf))
	{
		imname[0] = '\0';
		fscanf(pf, "%s", imname);
		if (imname[0] == 0)
			break;
		sprintf(s, "/usr/local/yh/bin/%s", imname);
		if (fork() == 0)
		{
			fclose(pf);
			if (execl(s, s, NULL) < 0)
			{
				printf("޷ִ%s\n", s);
				exit(0);
			}
		}
		else
			wait(NULL);
	}

	fclose(pf);
	puts("\033[0m");
}


static void	ExecShell(argv0)
char	*argv0;
{
	extern char	**environ;
	int		i;
	char		*newenv[128];
	char		path[256];
	char		*shell;
	char		*arg0;
	char		*argv[3];

	if (fdVGA != -1)
	{
		printf("\033[33;1m");
		puts("shellexitصӢ״̬");
		puts("\033[37;0m");
	}
	setenv("TERM","linux",1);
	i = 0;
	while (1)
	{
		if ((newenv[i] = environ[i]) == NULL)
			break;

		i++;
	}

	newenv[i++] = "YANHUANG=1";
	// newenv[i++] = "LANG=zh_CN.eucGB";
	newenv[i++] = "TERM=linux";
	newenv[i] = NULL;
	if (strcmp(argv0, "-yhksh") == 0)
		shell = "/bin/ksh";
	else if (strcmp(argv0, "-yhcsh") == 0)
		shell = "/bin/csh";
	else if (strcmp(argv0, "-yhsh") == 0)
		shell = "/bin/bsh";
	else
	{
		shell = getenv("SHELL");
		if (shell == NULL)
			shell = "/bin/bash";
	}

	if (argv0[0] == '-')
		arg0 = "-";
	else
		arg0 = shell;

	argv[0] = arg0;
	if (yhexec[0] == '\0')
		argv[1] = NULL;
	else
	{
		argv[1] = yhexec;
		argv[2] = NULL;
	}

	if (execve(shell, argv, newenv) < 0)
	{
		printf("޷ִ%s밴Enter˳\n", shell);
		getchar();
		exit(0);
	}
}


static void	CheckDate()
{
	time_t		clock;
	struct tm	*ptm;

	time(&clock);
	ptm = localtime(&clock);
	ptm->tm_mon++;
	if ((ptm->tm_year >= 99)) //&& (ptm->tm_mon >= 7))
	{
		printf("\033[36;1m");
		printf("%d%d%dաԲ׻ƽ̨ͰѾڡ\n",
			ptm->tm_year, ptm->tm_mon, ptm->tm_mday);
		puts("");
		puts("׻ƽ̨Ȥϵ");
		puts("绰    (010) 62544129(010) 62555043");
   		puts("          (13ֻ)  鿭(14ֻ)  (16ֻ)");
		puts("棺    (010) 62562533(010) 62544129-23");
   		puts("ͨѶַ8718һ ʱࣺ100080");
   		puts("");
		puts("֧ǷչĶлл");
		puts("");
		puts("밴Enter˻ص״̬");
		printf("\033[37;0m");
		getchar();
		exit(0);
	}
}


static void	DisplayTitle()
{
	char	*msgs[] =
	{
#ifdef GEMINI
		"\033[12m\215\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\214\033[10m",
		"\033[12m\231\033[10m                                                  \033[12m\231\033[10m",
		"\033[12m\231\033[10m            ӭ ʹ      ƽ ̨          \033[12m\231\033[10m",
		"\033[12m\231\033[10m                                                  \033[12m\231\033[10m",
		"\033[12m\231\033[10m               йѧԺо               \033[12m\231\033[10m",
		"\033[12m\231\033[10m            ϵͳϢ            \033[12m\231\033[10m",
		"\033[12m\231\033[10m      绰(010) 62645414 (010) 62555043         \033[12m\231\033[10m",
		"\033[12m\231\033[10m                                                  \033[12m\231\033[10m",
		"\033[12m\231\033[10m                1998 Ȩ                   \033[12m\231\033[10m",
		"\033[12m\231\033[10m                                                  \033[12m\231\033[10m",
		"\033[12m\216\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\222\213\033[10m",
		"",
#endif

#ifdef OPENSERVER
#ifdef STONE_OEM
		"\033[12mIMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m         ӭʹ CenterNet II ׻ƽ̨       \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m           For SCO Unix OpenServer V5.0.x         \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m  Unit 20, 380 Easrern Valley Way ʯ·3 \033[12m:\033[10m",
		"\033[12m:\033[10m  Roseville N.S.W 2069 Australia.                 \033[12m:\033[10m",
		"\033[12m:\033[10m  http://www.stonemicro.com.au    50542 \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12mHMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<\033[10m",
		"",
#else
		"\033[12mIMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM;\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m            ӭ ʹ      ƽ ̨          \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m               йѧԺо               \033[12m:\033[10m",
		"\033[12m:\033[10m            ϵͳϢ            \033[12m:\033[10m",
		"\033[12m:\033[10m      绰(010) 62645414 (010) 62555043         \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12m:\033[10m                1998 Ȩ                   \033[12m:\033[10m",
		"\033[12m:\033[10m                                                  \033[12m:\033[10m",
		"\033[12mHMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM<\033[10m",
		"",
#endif
#endif
		NULL
	};
	char	*setcolor = "\033[42;1;37m";
	char	*nocolor = "\033[40;0;37m";
	char	space[81];
	int		x;
	int		i;

	x = 15;
	memset(space, ' ', x);
	space[x] = '\0';

	i = 0;
	while (msgs[i] != NULL)
		printf("%s%s%s%s\n", space, setcolor, msgs[i++], nocolor);
}

