
#include "config.h"
#include "yodl.h"

#if ! HAVE_HSEARCH_R

void
init_hash_tables ()
{
}

#else /* HAVE_HSEARCH_R */

#include <search.h>
#include <errno.h>

void
create_hash_table (int n, struct hsearch_data* table_p)
{
  table_p->table = 0;
  hcreate_r (n, table_p);
}

void
init_hash_tables ()
{

#if 0
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)builtin);
#endif


#if 0
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)userdef);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)define);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)countername);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)nousermacro);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)chartabname);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)subst);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)subst_redef);
#else
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)userdef);
  create_hash_table (HSEARCH_MAX, (struct hsearch_data*)define);
  create_hash_table (50, (struct hsearch_data*)countername);
  create_hash_table (50, (struct hsearch_data*)nousermacro);
  create_hash_table (50, (struct hsearch_data*)chartabname);
  create_hash_table (50, (struct hsearch_data*)subst);
  create_hash_table (50, (struct hsearch_data*)subst_redef);
#endif
}

#endif /* HAVE_HSEARCH_R */

void
init ()
{
  struct Builtin *b;

  /*
    not necessary, but would allow size tuning
   */
#if 0
  init_hash_tables (); */
#endif
  
  /* load default macro names */
  b = builtins;
  while (b->func)
    {
      builtin = strarr_add (builtin, &nbuiltin, b->name);
      b++;
    }

  /*
    urg, should be fixed
   */
  error_setprogname ("yodl");	/* for error messages */

#if 0 /* def NDEBUG */
  /*  how can we expect people to help, if there's no core dump? */

  signal (SIGHUP, sighandler);	/* signal handler */
  signal (SIGINT, sighandler);
  signal (SIGQUIT, sighandler);
  signal (SIGTERM, sighandler);
  signal (SIGSEGV, sighandler);
#endif

  /* init global variables */
  outf = stdout;
  maxpass = DEFAULT_MAXPASS;
  dont_do_expand_global = 0;
}

