
#include "yodlfixlabels.h"

void 
handletag (char *buf, int pass)
{
  char
  **table = 0;			/* storage for split up line */
  int
    ntable = 0;			/* table size */
  char
   *cp;

  cp = strtok (buf, " \t\n");	/* split up into table */
  while (cp)
    {
      table = strarr_add (table, &ntable, cp);
      if (cp && !strcmp (cp, TAGEND))
	break;
      cp = strtok (NULL, " \t\n");
    }

  if (ntable < 3)
    error ("near line %d: tagged construction has no tag", lineno);

  /* lastnumber, label, ref */
  if (!strcmp (table[1], "lastnumber") && act.labels)
    lastnumber (table, ntable, pass);	/* handle lastnumber tags */
  else if (!strcmp (table[1], "label") && act.labels)
    label (table, ntable, pass);	/* handle label tags */
  else if (!strcmp (table[1], "ref") && act.labels)
    ref (table, ntable, pass);	/* handle ref tags */

  /* tableofcontents, tocentry */
  else if (!strcmp (table[1], "tableofcontents") && act.tableofcontents)
    tableofcontents (pass);	/* create toc */
  else if (!strcmp (table[1], "tocentry") && act.tableofcontents)
    tocentry (table, ntable, pass);	/* set toc entry */

  /* startremoveblank, endremoveblank */
  else if (!strcmp (table[1], "startremoveblank") && act.removeblank)
    act.killblanks = 1;
  else if (!strcmp (table[1], "endremoveblank") && act.removeblank)
    act.killblanks = 0;

  /* roffcmd */
  else if (!strcmp (table[1], "roffcmd") && act.roff)
    roffcmd (table, ntable, pass);

  /* defaults */
  else if (pass)
    dumptable (table, 0, ntable);	/* dump to output */

  strarr_free (table, ntable);
}
