/* Shared definitions for GNU shar utilities.
   Copyright (C) 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_FEATURES_H
# define _GNU_SOURCE
# include <features.h>
#endif

#ifdef HAVE_WINDOWS_H
# define WIN32_LEAN_AND_MEAN
# include <windows.h>
# if defined(WIN32) && defined(__STRICT_ANSI__)
#  undef __STRICT_ANSI__
# endif
#endif

#if __STDC__
# define voidstar void *
#else
# define voidstar char *
#endif

#if STDC_HEADERS
# include <stdlib.h>
# include <stddef.h>
#else
# ifdef HAVE_STDLIB_H
#  include <stdlib.h>
# endif
#endif

/* Some systems do not define EXIT_*, even with STDC_HEADERS.  */
#ifndef EXIT_SUCCESS
# define EXIT_SUCCESS 0
#endif
#ifndef EXIT_FAILURE
# define EXIT_FAILURE 1
#endif

#ifdef HAVE_STRING_H
# if !STDC_HEADERS && defined(HAVE_MEMORY_H)
#  include <memory.h>
# endif
# include <string.h>
# ifndef strdup
  extern char *strdup (const char * s1);
# endif
#endif

#ifdef HAVE_STRINGS_H
# include <strings.h>
#endif

#ifndef HAVE_STRCHR
# ifndef strchr
#  define strchr(s, c) index(s, c)
# endif
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_INTTYPES_H
# include <inttypes.h>
#else
# ifdef HAVE_STDINT_H
#  include <stdint.h>
# endif
#endif

#ifdef HAVE_ATOLL
# ifndef atol
#  define atol(s) atoll(s)
# endif
#endif

/* Other header files.  */
#include <stdio.h>

#ifdef HAVE_FSEEKO
# ifdef fseek
#  undef fseek
# endif
# define fseek(stream, offs, whence) fseeko(stream, offs, whence)
#endif

#include <errno.h>
#ifndef errno
extern int errno;
#endif

#ifdef HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

/* Get definitions for the file permission bits.  */
#ifdef HAVE_SYS_STAT_H
# include <sys/stat.h>
#endif

#ifdef STAT_MACROS_BROKEN
# undef S_ISDIR
# undef S_ISREG
#endif

#ifndef S_IFMT
# define S_IFMT 0170000
#endif
#if !defined(S_ISDIR) && defined(S_IFDIR)
# define S_ISDIR(Mode) (((Mode) & S_IFMT) == S_IFDIR)
#endif
#if !defined(S_ISREG) && defined(S_IFREG)
# define S_ISREG(Mode) (((Mode) & S_IFMT) == S_IFREG)
#endif

#ifndef S_IRWXU
# define S_IRWXU 0700
#endif
#ifndef S_IRUSR
# define S_IRUSR 0400
#endif
#ifndef S_IWUSR
# define S_IWUSR 0200
#endif
#ifndef S_IXUSR
# define S_IXUSR 0100
#endif

#ifndef S_IRWXG
# define S_IRWXG 0070
#endif
#ifndef S_IRGRP
# define S_IRGRP 0040
#endif
#ifndef S_IWGRP
# define S_IWGRP 0020
#endif
#ifndef S_IXGRP
# define S_IXGRP 0010
#endif

#ifndef S_IRWXO
# define S_IRWXO 0007
#endif
#ifndef S_IROTH
# define S_IROTH 0004
#endif
#ifndef S_IWOTH
# define S_IWOTH 0002
#endif
#ifndef S_IXOTH
# define S_IXOTH 0001
#endif

/* System functions.  Even if we usually avoid declaring them, we cannot
   avoid them all.  */
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_FCNTL_H
# include <fcntl.h>
#endif

#ifdef __DJGPP__
#include <io.h>
#endif /* __DJGPP__ */

/* GNU small library functions.  */
#ifndef __P
# if PROTOTYPES
#  define __P(Args) Args
# else
#  define __P(Args) ()
# endif
#endif

#ifdef HAVE_LOCALE_H
# include <locale.h>
#else
# define setlocale(Category, Locale)
#endif

/*#ifdef HAVE_LIBINTL_H
# include <libintl.h>
# define _(Str) gettext (Str)
#else*/
# define _(Str) (Str)
/*#endif*/

/*#ifndef gettext
# define gettext(Str) (Str)
#endif*/

/*#ifdef gettext_noop
# define N_(Str) gettext_noop (Str)
#else*/
# define N_(Str) (Str)
/*#endif*/

void error __P ((int, int, const char *, ...));

