CREATE TABLE acknowledges_tmp (
        acknowledgeid           number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        eventid         number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        message         varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (acknowledgeid)
);
CREATE INDEX acknowledges_1 on acknowledges_tmp (userid);
CREATE INDEX acknowledges_2 on acknowledges_tmp (eventid);
CREATE INDEX acknowledges_3 on acknowledges_tmp (clock);

insert into acknowledges_tmp select * from acknowledges;
drop trigger acknowledges_trigger;
drop sequence acknowledges_acknowledgeid;
drop table acknowledges;
alter table acknowledges_tmp rename to acknowledges;
CREATE TABLE actions_tmp (
        actionid                number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(255)           DEFAULT ''      ,
        eventsource             number(10)              DEFAULT '0'     NOT NULL,
        evaltype                number(10)              DEFAULT '0'     NOT NULL,
        status          number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (actionid)
);

CREATE TABLE operations (
        operationid             number(20)              DEFAULT '0'     NOT NULL,
        actionid                number(20)              DEFAULT '0'     NOT NULL,
        operationtype           number(10)              DEFAULT '0'     NOT NULL,
        object          number(10)              DEFAULT '0'     NOT NULL,
        objectid                number(20)              DEFAULT '0'     NOT NULL,
        shortdata               varchar2(255)           DEFAULT ''      ,
        longdata                varchar2(2048)          DEFAULT ''      ,
        scripts_tmp             varchar2(2048)          DEFAULT ''      ,
        PRIMARY KEY (operationid)
);
CREATE INDEX operations_1 on operations (actionid);

insert into actions_tmp select actionid,actionid,source,0,status from actions;

insert into operations select actionid,actionid,actiontype,recipient,userid,subject,message,scripts from actions;
update operations set longdata=scripts_tmp where operationtype=1;
alter table operations drop column scripts_tmp;

drop trigger actions_trigger;
drop sequence actions_actionid;
drop table actions;
alter table actions_tmp rename to actions;
CREATE TABLE alerts_tmp (
        alertid         number(20)              DEFAULT '0'     NOT NULL,
        actionid                number(20)              DEFAULT '0'     NOT NULL,
        triggerid               number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        mediatypeid             number(20)              DEFAULT '0'     NOT NULL,
        sendto          varchar2(100)           DEFAULT ''      ,
        subject         varchar2(255)           DEFAULT ''      ,
        message         varchar2(2048)          DEFAULT ''      ,
        status          number(10)              DEFAULT '0'     NOT NULL,
        retries         number(10)              DEFAULT '0'     NOT NULL,
        error           varchar2(128)           DEFAULT ''      ,
        nextcheck               number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (alertid)
);
CREATE INDEX alerts_1 on alerts_tmp (actionid);
CREATE INDEX alerts_2 on alerts_tmp (clock);
CREATE INDEX alerts_3 on alerts_tmp (triggerid);
CREATE INDEX alerts_4 on alerts_tmp (status,retries);
CREATE INDEX alerts_5 on alerts_tmp (mediatypeid);
CREATE INDEX alerts_6 on alerts_tmp (userid);

insert into alerts_tmp select alertid,actionid,triggerid,userid,clock,mediatypeid,sendto,subject,message,status,retries,error,nextcheck from alerts;
drop trigger alerts_trigger;
drop sequence alerts_alertid;
drop table alerts;
alter table alerts_tmp rename to alerts;
CREATE TABLE applications_tmp (
        applicationid           number(20)              DEFAULT '0'     NOT NULL,
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(255)           DEFAULT ''      ,
        templateid              number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (applicationid)
);
CREATE INDEX applications_1 on applications_tmp (templateid);
CREATE UNIQUE INDEX applications_2 on applications_tmp (hostid,name);

insert into applications_tmp select * from applications;
drop trigger applications_trigger;
drop sequence applications_applicationid;
drop table applications;
alter table applications_tmp rename to applications;
CREATE TABLE auditlog_tmp (
        auditid         number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        action          number(10)              DEFAULT '0'     NOT NULL,
        resourcetype            number(10)              DEFAULT '0'     NOT NULL,
        details         varchar2(128)           DEFAULT '0'     ,
        PRIMARY KEY (auditid)
);
CREATE INDEX auditlog_1 on auditlog_tmp (userid,clock);
CREATE INDEX auditlog_2 on auditlog_tmp (clock);

insert into auditlog_tmp select * from auditlog;
drop trigger auditlog_trigger;
drop sequence auditlog_auditid;
drop table auditlog;
alter table auditlog_tmp rename to auditlog;
drop trigger autoreg_trigger;
drop sequence autoreg_id;
drop table autoreg;
CREATE TABLE conditions_tmp (
        conditionid             number(20)              DEFAULT '0'     NOT NULL,
        actionid                number(20)              DEFAULT '0'     NOT NULL,
        conditiontype           number(10)              DEFAULT '0'     NOT NULL,
        operator                number(10)              DEFAULT '0'     NOT NULL,
        value           varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (conditionid)
);
CREATE INDEX conditions_1 on conditions_tmp (actionid);

insert into conditions_tmp select * from conditions;
drop trigger conditions_trigger;
drop sequence conditions_conditionid;
drop table conditions;
alter table conditions_tmp rename to conditions;
CREATE TABLE config_tmp (
        configid                number(20)              DEFAULT '0'     NOT NULL,
        alert_history           number(10)              DEFAULT '0'     NOT NULL,
        event_history           number(10)              DEFAULT '0'     NOT NULL,
        refresh_unsupported             number(10)              DEFAULT '0'     NOT NULL,
        work_period             varchar2(100)           DEFAULT '1-5,00:00-24:00'       ,
        alert_usrgrpid          number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (configid)
);

insert into config_tmp select 1,alert_history,alarm_history,refresh_unsupported,work_period,0 from config;
drop table config;
alter table config_tmp rename to config;
CREATE TABLE dchecks (
        dcheckid                number(20)              DEFAULT '0'     NOT NULL,
        druleid         number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        key_            varchar2(255)           DEFAULT '0'     ,
        snmp_community          varchar2(255)           DEFAULT '0'     ,
        ports           varchar2(255)           DEFAULT '0'     ,
        PRIMARY KEY (dcheckid)
);
CREATE TABLE dhosts (
        dhostid         number(20)              DEFAULT '0'     NOT NULL,
        druleid         number(20)              DEFAULT '0'     NOT NULL,
        ip              varchar2(15)            DEFAULT ''      ,
        status          number(10)              DEFAULT '0'     NOT NULL,
        lastup          number(10)              DEFAULT '0'     NOT NULL,
        lastdown                number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (dhostid)
);
CREATE TABLE drules (
        druleid         number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(255)           DEFAULT ''      ,
        iprange         varchar2(255)           DEFAULT ''      ,
        delay           number(10)              DEFAULT '0'     NOT NULL,
        nextcheck               number(10)              DEFAULT '0'     NOT NULL,
        status          number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (druleid)
);
CREATE TABLE dservices (
        dserviceid              number(20)              DEFAULT '0'     NOT NULL,
        dhostid         number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        key_            varchar2(255)           DEFAULT '0'     ,
        value           varchar2(255)           DEFAULT '0'     ,
        port            number(10)              DEFAULT '0'     NOT NULL,
        status          number(10)              DEFAULT '0'     NOT NULL,
        lastup          number(10)              DEFAULT '0'     NOT NULL,
        lastdown                number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (dserviceid)
);
CREATE TABLE events (
        eventid         number(20)              DEFAULT '0'     NOT NULL,
        source          number(10)              DEFAULT '0'     NOT NULL,
        object          number(10)              DEFAULT '0'     NOT NULL,
        objectid                number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           number(10)              DEFAULT '0'     NOT NULL,
        acknowledged            number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (eventid)
);
CREATE INDEX events_1 on events (object,objectid,clock);
CREATE INDEX events_2 on events (clock);

insert into events select alarmid,0,0,triggerid,clock,value,acknowledged from alarms;
drop trigger alarms_trigger;
drop sequence alarms_alarmid;
drop table alarms;
CREATE TABLE functions_tmp (
        functionid              number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        triggerid               number(20)              DEFAULT '0'     NOT NULL,
        lastvalue               varchar2(255)                   ,
        function                varchar2(12)            DEFAULT ''      ,
        parameter               varchar2(255)           DEFAULT '0'     ,
        PRIMARY KEY (functionid)
);
CREATE INDEX functions_1 on functions_tmp (triggerid);
CREATE INDEX functions_2 on functions_tmp (itemid,function,parameter);

insert into functions_tmp select * from functions;
drop trigger functions_trigger;
drop sequence functions_functionid;
drop table functions;
alter table functions_tmp rename to functions;
CREATE TABLE graphs_items_tmp (
        gitemid         number(20)              DEFAULT '0'     NOT NULL,
        graphid         number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        drawtype                number(10)              DEFAULT '0'     NOT NULL,
        sortorder               number(10)              DEFAULT '0'     NOT NULL,
        color           varchar2(32)            DEFAULT 'Dark Green'    ,
        yaxisside               number(10)              DEFAULT '1'     NOT NULL,
        calc_fnc                number(10)              DEFAULT '2'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        periods_cnt             number(10)              DEFAULT '5'     NOT NULL,
        PRIMARY KEY (gitemid)
);

insert into graphs_items_tmp select * from graphs_items;
drop trigger graphs_items_trigger;
drop sequence graphs_items_gitemid;
drop table graphs_items;
alter table graphs_items_tmp rename to graphs_items;
CREATE TABLE graphs_tmp (
        graphid         number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(128)           DEFAULT ''      ,
        width           number(10)              DEFAULT '0'     NOT NULL,
        height          number(10)              DEFAULT '0'     NOT NULL,
        yaxistype               number(10)              DEFAULT '0'     NOT NULL,
        yaxismin                number(20,4)            DEFAULT '0'     NOT NULL,
        yaxismax                number(20,4)            DEFAULT '0'     NOT NULL,
        templateid              number(20)              DEFAULT '0'     NOT NULL,
        show_work_period                number(10)              DEFAULT '1'     NOT NULL,
        show_triggers           number(10)              DEFAULT '1'     NOT NULL,
        graphtype               number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (graphid)
);
CREATE INDEX graphs_graphs_1 on graphs_tmp (name);

insert into graphs_tmp select graphid,name,width,height,yaxistype,yaxismin,yaxismax,templateid,show_work_period,show_triggers,0 from graphs;
drop trigger graphs_trigger;
drop sequence graphs_graphid;
drop table graphs;
alter table graphs_tmp rename to graphs;
CREATE TABLE groups_tmp (
        groupid         number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT ''      ,
        PRIMARY KEY (groupid)
);
CREATE INDEX groups_1 on groups_tmp (name);

insert into groups_tmp select groupid,name from groups;
drop trigger groups_trigger;
drop sequence groups_groupid;
drop table groups;
alter table groups_tmp rename to groups;
CREATE TABLE help_items_tmp (
        itemtype                number(10)              DEFAULT '0'     NOT NULL,
        key_            varchar2(255)           DEFAULT ''      ,
        description             varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (itemtype,key_)
);

insert into help_items_tmp select * from help_items;
drop table help_items;
alter table help_items_tmp rename to help_items;
CREATE TABLE history_log_tmp (
        id              number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        timestamp               number(10)              DEFAULT '0'     NOT NULL,
        source          varchar2(64)            DEFAULT ''      ,
        severity                number(10)              DEFAULT '0'     NOT NULL,
        value           varchar2(2048)          DEFAULT ''      ,
        PRIMARY KEY (id)
);
CREATE INDEX history_log_1 on history_log_tmp (itemid,clock);

insert into history_log_tmp select * from history_log;
drop trigger history_log_trigger;
drop sequence history_log_id;
drop table history_log;
alter table history_log_tmp rename to history_log;
CREATE TABLE history_tmp (
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           number(20,4)            DEFAULT '0.0000'        NOT NULL
);
CREATE INDEX history_1 on history_tmp (itemid,clock);

insert into history_tmp select * from history;
drop table history;
alter table history_tmp rename to history;
CREATE TABLE history_str_tmp (
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           varchar2(255)           DEFAULT ''
);
CREATE INDEX history_str_1 on history_str_tmp (itemid,clock);

insert into history_str_tmp select * from history_str;
drop table history_str;
alter table history_str_tmp rename to history_str;
CREATE TABLE history_str_sync (
        id              number(20)                      ,
        nodeid          number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (id)
);
CREATE INDEX history_str_sync_1 on history_str_sync (nodeid,id);

create sequence history_str_sync_id
start with 1
increment by 1
nomaxvalue;

create trigger history_str_sync_trigger
before insert on history_str_sync
for each row
begin
	if (:new.id is null or :new.id = 0) then
		select history_str_sync_id.nextval into :new.id from dual;
	end if;
end;
/
CREATE TABLE history_sync (
        id              number(20)                      ,
        nodeid          number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           number(20,4)            DEFAULT '0.0000'        NOT NULL,
        PRIMARY KEY (id)
);
CREATE INDEX history_sync_1 on history_sync (nodeid,id);

create sequence history_sync_id
start with 1
increment by 1
nomaxvalue;

create trigger history_sync_trigger
before insert on history_sync
for each row
begin
        if (:new.id is null or :new.id = 0) then
                select history_sync_id.nextval into :new.id from dual;
        end if;
end;
/
CREATE TABLE history_text_tmp (
        id              number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           clob            DEFAULT ''      NOT NULL,
        PRIMARY KEY (id)
);
CREATE INDEX history_text_1 on history_text_tmp (itemid,clock);

create sequence history_text_tmp_id
start with 1
increment by 1
nomaxvalue;

create trigger history_text_tmp_trigger
before insert on history_text_tmp
for each row
begin
	select history_text_tmp_id.nextval into :new.id from dual;
end;
/

insert into history_text_tmp select NULL,itemid,clock,value from history_text;
drop trigger history_text_tmp_trigger;
drop sequence history_text_tmp_id;
drop table history_text;
alter table history_text_tmp rename to history_text;
CREATE TABLE history_uint_tmp (
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           number(20)              DEFAULT '0'     NOT NULL
);
CREATE INDEX history_uint_1 on history_uint_tmp (itemid,clock);

insert into history_uint_tmp select * from history_uint;
drop table history_uint;
alter table history_uint_tmp rename to history_uint;
CREATE TABLE history_uint_sync (
        id              number(20)                      ,
        nodeid          number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        value           number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (id)
);
CREATE INDEX history_uint_sync_1 on history_uint_sync (nodeid,id);

create sequence history_uint_sync_id
start with 1
increment by 1
nomaxvalue;

create trigger history_uint_sync_trigger
before insert on history_uint_sync
for each row
begin
        if (:new.id is null or :new.id = 0) then
                select history_uint_sync_id.nextval into :new.id from dual;
        end if;
end;
/
CREATE TABLE hosts_groups_tmp (
        hostgroupid             number(20)              DEFAULT '0'     NOT NULL,
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        groupid         number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (hostgroupid)
);
CREATE INDEX hosts_groups_groups_1 on hosts_groups_tmp (hostid,groupid);

create sequence hosts_groups_tmp_hostgroupid
start with 1
increment by 1
nomaxvalue;

create trigger hosts_groups_tmp_trigger
before insert on hosts_groups_tmp
for each row
begin
	select hosts_groups_tmp_hostgroupid.nextval into :new.hostgroupid from dual;
end;
/

insert into hosts_groups_tmp (hostid,groupid) select hostid,groupid from hosts_groups;
drop trigger hosts_groups_tmp_trigger;
drop sequence hosts_groups_tmp_hostgroupid;
drop table hosts_groups;
alter table hosts_groups_tmp rename to hosts_groups;
CREATE TABLE hosts_profiles_tmp (
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        devicetype              varchar2(64)            DEFAULT ''      ,
        name            varchar2(64)            DEFAULT ''      ,
        os              varchar2(64)            DEFAULT ''      ,
        serialno                varchar2(64)            DEFAULT ''      ,
        tag             varchar2(64)            DEFAULT ''      ,
        macaddress              varchar2(64)            DEFAULT ''      ,
        hardware                varchar2(2048)          DEFAULT ''      ,
        software                varchar2(2048)          DEFAULT ''      ,
        contact         varchar2(2048)          DEFAULT ''      ,
        location                varchar2(2048)          DEFAULT ''      ,
        notes           varchar2(2048)          DEFAULT ''      ,
        PRIMARY KEY (hostid)
);

insert into hosts_profiles_tmp select * from hosts_profiles;
drop table hosts_profiles;
alter table hosts_profiles_tmp rename to hosts_profiles;
-- See hosts_templates.sql
drop trigger hosts_templates_trigger;
drop sequence hosts_templates_hosttemplateid;
drop table hosts_templates;

CREATE TABLE hosts_templates (
        hosttemplateid          number(20)              DEFAULT '0'     NOT NULL,
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        templateid              number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (hosttemplateid)
);
CREATE UNIQUE INDEX hosts_templates_1 on hosts_templates (hostid,templateid);

insert into hosts_templates select hostid,hostid,templateid from hosts where templateid<>0;

-- hosts.sql

CREATE TABLE hosts_tmp (
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        host            varchar2(64)            DEFAULT ''      ,
        dns             varchar2(64)            DEFAULT ''      ,
        useip           number(10)              DEFAULT '1'     NOT NULL,
        ip              varchar2(15)            DEFAULT '127.0.0.1'     ,
        port            number(10)              DEFAULT '10050' NOT NULL,
        status          number(10)              DEFAULT '0'     NOT NULL,
        disable_until           number(10)              DEFAULT '0'     NOT NULL,
        error           varchar2(128)           DEFAULT ''      ,
        available               number(10)              DEFAULT '0'     NOT NULL,
        errors_from             number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (hostid)
);
CREATE INDEX hosts_1 on hosts_tmp (host);
CREATE INDEX hosts_2 on hosts_tmp (status);

insert into hosts_tmp select hostid,host,host,useip,ip,port,status,disable_until,error,available,errors_from from hosts;
drop trigger hosts_trigger;
drop sequence hosts_hostid;
drop table hosts;
alter table hosts_tmp rename to hosts;
CREATE TABLE housekeeper_tmp (
        housekeeperid           number(20)              DEFAULT '0'     NOT NULL,
        tablename               varchar2(64)            DEFAULT ''      ,
        field           varchar2(64)            DEFAULT ''      ,
        value           number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (housekeeperid)
);

insert into housekeeper_tmp select * from housekeeper;
drop trigger housekeeper_trigger;
drop sequence housekeeper_housekeeperid;
drop table housekeeper;
alter table housekeeper_tmp rename to housekeeper;
CREATE TABLE httpstepitem (
        httpstepitemid          number(20)              DEFAULT '0'     NOT NULL,
        httpstepid              number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (httpstepitemid)
);
CREATE UNIQUE INDEX httpstepitem_httpstepitem_1 on httpstepitem (httpstepid,itemid);
CREATE TABLE httpstep (
        httpstepid              number(20)              DEFAULT '0'     NOT NULL,
        httptestid              number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT ''      ,
        no              number(10)              DEFAULT '0'     NOT NULL,
        url             varchar2(128)           DEFAULT ''      ,
        timeout         number(10)              DEFAULT '30'    NOT NULL,
        posts           varchar2(2048)          DEFAULT ''      ,
        required                varchar2(255)           DEFAULT ''      ,
        status_codes            varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (httpstepid)
);
CREATE INDEX httpstep_httpstep_1 on httpstep (httptestid);
CREATE TABLE httptestitem (
        httptestitemid          number(20)              DEFAULT '0'     NOT NULL,
        httptestid              number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (httptestitemid)
);
CREATE UNIQUE INDEX httptestitem_httptestitem_1 on httptestitem (httptestid,itemid);
CREATE TABLE httptest (
        httptestid              number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT ''      ,
        applicationid           number(20)              DEFAULT '0'     NOT NULL,
        lastcheck               number(10)              DEFAULT '0'     NOT NULL,
        nextcheck               number(10)              DEFAULT '0'     NOT NULL,
        curstate                number(10)              DEFAULT '0'     NOT NULL,
        curstep         number(10)              DEFAULT '0'     NOT NULL,
        lastfailedstep          number(10)              DEFAULT '0'     NOT NULL,
        delay           number(10)              DEFAULT '60'    NOT NULL,
        status          number(10)              DEFAULT '0'     NOT NULL,
        macros          varchar2(2048)          DEFAULT ''      ,
        agent           varchar2(255)           DEFAULT ''      ,
        time            number(20,4)            DEFAULT '0'     NOT NULL,
        error           varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (httptestid)
);
CREATE TABLE ids (
        nodeid          number(10)              DEFAULT '0'     NOT NULL,
        table_name              varchar2(64)            DEFAULT ''      ,
        field_name              varchar2(64)            DEFAULT ''      ,
        nextid          number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (nodeid,table_name,field_name)
);
CREATE TABLE images_tmp (
        imageid         number(20)              DEFAULT '0'     NOT NULL,
        imagetype               number(10)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT '0'     ,
        image           blob            DEFAULT ''      NOT NULL,
        PRIMARY KEY (imageid)
);
CREATE INDEX images_1 on images_tmp (imagetype,name);

insert into images_tmp select * from images;
drop trigger images_trigger;
drop sequence images_imageid;
drop table images;
alter table images_tmp rename to images;
CREATE TABLE items_applications_tmp (
        itemappid               number(20)              DEFAULT '0'     NOT NULL,
        applicationid           number(20)              DEFAULT '0'     NOT NULL,
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (itemappid)
);
CREATE INDEX items_applications_1 on items_applications_tmp (applicationid,itemid);
CREATE INDEX items_applications_2 on items_applications_tmp (itemid);

create sequence itemapp_tmp_itemappid
start with 1
increment by 1
nomaxvalue;

create trigger itemapp_tmp_trigger
before insert on items_applications_tmp
for each row
begin
	select itemapp_tmp_itemappid.nextval into :new.itemappid from dual;
end;
/

insert into items_applications_tmp select NULL,applicationid,itemid from items_applications;
drop trigger itemapp_tmp_trigger;
drop sequence itemapp_tmp_itemappid;
drop table items_applications;
alter table items_applications_tmp rename to items_applications;
CREATE TABLE items_tmp (
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        snmp_community          varchar2(64)            DEFAULT ''      ,
        snmp_oid                varchar2(255)           DEFAULT ''      ,
        snmp_port               number(10)              DEFAULT '161'   NOT NULL,
        hostid          number(20)              DEFAULT '0'     NOT NULL,
        description             varchar2(255)           DEFAULT ''      ,
        key_            varchar2(255)           DEFAULT ''      ,
        delay           number(10)              DEFAULT '0'     NOT NULL,
        history         number(10)              DEFAULT '90'    NOT NULL,
        trends          number(10)              DEFAULT '365'   NOT NULL,
        nextcheck               number(10)              DEFAULT '0'     NOT NULL,
        lastvalue               varchar2(255)                   ,
        lastclock               number(10)                      NULL,
        prevvalue               varchar2(255)                   ,
        status          number(10)              DEFAULT '0'     NOT NULL,
        value_type              number(10)              DEFAULT '0'     NOT NULL,
        trapper_hosts           varchar2(255)           DEFAULT ''      ,
        units           varchar2(10)            DEFAULT ''      ,
        multiplier              number(10)              DEFAULT '0'     NOT NULL,
        delta           number(10)              DEFAULT '0'     NOT NULL,
        prevorgvalue            varchar2(255)                   ,
        snmpv3_securityname             varchar2(64)            DEFAULT ''      ,
        snmpv3_securitylevel            number(10)              DEFAULT '0'     NOT NULL,
        snmpv3_authpassphrase           varchar2(64)            DEFAULT ''      ,
        snmpv3_privpassphrase           varchar2(64)            DEFAULT ''      ,
        formula         varchar2(255)           DEFAULT '1'     ,
        error           varchar2(128)           DEFAULT ''      ,
        lastlogsize             number(10)              DEFAULT '0'     NOT NULL,
        logtimefmt              varchar2(64)            DEFAULT ''      ,
        templateid              number(20)              DEFAULT '0'     NOT NULL,
        valuemapid              number(20)              DEFAULT '0'     NOT NULL,
        delay_flex              varchar2(255)           DEFAULT ''      ,
        params          varchar2(2048)          DEFAULT ''      ,
        PRIMARY KEY (itemid)
);
CREATE UNIQUE INDEX items_1 on items_tmp (hostid,key_);
CREATE INDEX items_2 on items_tmp (nextcheck);
CREATE INDEX items_3 on items_tmp (status);

insert into items_tmp (itemid,type,snmp_community,snmp_oid,snmp_port,hostid,description,key_,delay,history,trends,nextcheck,lastvalue,lastclock,prevvalue,status,value_type,trapper_hosts,units,multiplier,delta,prevorgvalue,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,formula,error,lastlogsize,logtimefmt,templateid,valuemapid,delay_flex,params) select itemid,type,snmp_community,snmp_oid,snmp_port,hostid,description,key_,delay,history,trends,nextcheck,lastvalue,lastclock,prevvalue,status,value_type,trapper_hosts,units,multiplier,delta,prevorgvalue,snmpv3_securityname,snmpv3_securitylevel,snmpv3_authpassphrase,snmpv3_privpassphrase,formula,error,lastlogsize,logtimefmt,templateid,valuemapid,'','' from items;
drop trigger items_trigger;
drop sequence items_itemid;
drop table items;
alter table items_tmp rename to items;
CREATE TABLE mappings_tmp (
        mappingid               number(20)              DEFAULT '0'     NOT NULL,
        valuemapid              number(20)              DEFAULT '0'     NOT NULL,
        value           varchar2(64)            DEFAULT ''      ,
        newvalue                varchar2(64)            DEFAULT ''      ,
        PRIMARY KEY (mappingid)
);
CREATE INDEX mappings_1 on mappings_tmp (valuemapid);

insert into mappings_tmp select * from mappings;
drop trigger mappings_trigger;
drop sequence mappings_mappingid;
drop table mappings;
alter table mappings_tmp rename to mappings;
CREATE TABLE media_tmp (
        mediaid         number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        mediatypeid             number(20)              DEFAULT '0'     NOT NULL,
        sendto          varchar2(100)           DEFAULT ''      ,
        active          number(10)              DEFAULT '0'     NOT NULL,
        severity                number(10)              DEFAULT '63'    NOT NULL,
        period          varchar2(100)           DEFAULT '1-7,00:00-23:59'       ,
        PRIMARY KEY (mediaid)
);
CREATE INDEX media_1 on media_tmp (userid);
CREATE INDEX media_2 on media_tmp (mediatypeid);

insert into media_tmp select * from media;
drop trigger media_trigger;
drop sequence media_mediaid;
drop table media;
alter table media_tmp rename to media;
CREATE TABLE media_type_tmp (
        mediatypeid             number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        description             varchar2(100)           DEFAULT ''      ,
        smtp_server             varchar2(255)           DEFAULT ''      ,
        smtp_helo               varchar2(255)           DEFAULT ''      ,
        smtp_email              varchar2(255)           DEFAULT ''      ,
        exec_path               varchar2(255)           DEFAULT ''      ,
        gsm_modem               varchar2(255)           DEFAULT ''      ,
        username                varchar2(255)           DEFAULT ''      ,
        passwd          varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (mediatypeid)
);

insert into media_type_tmp select mediatypeid,type,description,smtp_server,smtp_helo,smtp_email,exec_path,gsm_modem,'','' from media_type;
drop trigger media_type_trigger;
drop sequence media_type_mediatypeid;
drop table media_type;
alter table media_type_tmp rename to media_type;
CREATE TABLE node_cksum (
        cksumid         number(20)              DEFAULT '0'     NOT NULL,
        nodeid          number(20)              DEFAULT '0'     NOT NULL,
        tablename               varchar2(64)            DEFAULT ''      ,
        fieldname               varchar2(64)            DEFAULT ''      ,
        recordid                number(20)              DEFAULT '0'     NOT NULL,
        cksumtype               number(10)              DEFAULT '0'     NOT NULL,
        cksum           varchar2(32)            DEFAULT ''      ,
        PRIMARY KEY (cksumid)
);
CREATE INDEX node_cksum_cksum_1 on node_cksum (nodeid,tablename,fieldname,recordid,cksumtype);
CREATE TABLE node_configlog (
        conflogid               number(20)              DEFAULT '0'     NOT NULL,
        nodeid          number(20)              DEFAULT '0'     NOT NULL,
        tablename               varchar2(64)            DEFAULT ''      ,
        recordid                number(20)              DEFAULT '0'     NOT NULL,
        operation               number(10)              DEFAULT '0'     NOT NULL,
        sync_master             number(10)              DEFAULT '0'     NOT NULL,
        sync_slave              number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (nodeid,conflogid)
);
CREATE INDEX node_configlog_configlog_1 on node_configlog (conflogid);
CREATE INDEX node_configlog_configlog_2 on node_configlog (nodeid,tablename);
CREATE TABLE nodes (
        nodeid          number(10)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT '0'     ,
        timezone                number(10)              DEFAULT '0'     NOT NULL,
        ip              varchar2(15)            DEFAULT ''      ,
        port            number(10)              DEFAULT '10051' NOT NULL,
        slave_history           number(10)              DEFAULT '30'    NOT NULL,
        slave_trends            number(10)              DEFAULT '365'   NOT NULL,
        event_lastid            number(20)              DEFAULT '0'     NOT NULL,
        history_lastid          number(20)              DEFAULT '0'     NOT NULL,
        history_str_lastid              number(20)              DEFAULT '0'     NOT NULL,
        history_uint_lastid             number(20)              DEFAULT '0'     NOT NULL,
        nodetype                number(10)              DEFAULT '0'     NOT NULL,
        masterid                number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (nodeid)
);
-- See actions.sql
CREATE TABLE profiles_tmp (
        profileid               number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        idx             varchar2(64)            DEFAULT ''      ,
        value           varchar2(255)           DEFAULT ''      ,
        valuetype               number(10)              DEFAULT 0       NOT NULL,
        PRIMARY KEY (profileid)
);
CREATE UNIQUE INDEX profiles_1 on profiles_tmp (userid,idx);

insert into profiles_tmp select * from profiles;
drop trigger profiles_trigger;
drop sequence profiles_profileid;
drop table profiles;
alter table profiles_tmp rename to profiles;
CREATE TABLE rights_tmp (
        rightid         number(20)              DEFAULT '0'     NOT NULL,
        groupid         number(20)              DEFAULT '0'     NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        permission              number(10)              DEFAULT '0'     NOT NULL,
        id              number(20)                      ,
        PRIMARY KEY (rightid)
);
CREATE INDEX rights_1 on rights_tmp (groupid);

-- insert into rights_tmp select * from rights;
drop trigger rights_trigger;
drop sequence rights_rightid;
drop table rights;
alter table rights_tmp rename to rights;
CREATE TABLE screens_items_tmp (
        screenitemid            number(20)              DEFAULT '0'     NOT NULL,
        screenid                number(20)              DEFAULT '0'     NOT NULL,
        resourcetype            number(10)              DEFAULT '0'     NOT NULL,
        resourceid              number(20)              DEFAULT '0'     NOT NULL,
        width           number(10)              DEFAULT '320'   NOT NULL,
        height          number(10)              DEFAULT '200'   NOT NULL,
        x               number(10)              DEFAULT '0'     NOT NULL,
        y               number(10)              DEFAULT '0'     NOT NULL,
        colspan         number(10)              DEFAULT '0'     NOT NULL,
        rowspan         number(10)              DEFAULT '0'     NOT NULL,
        elements                number(10)              DEFAULT '25'    NOT NULL,
        valign          number(10)              DEFAULT '0'     NOT NULL,
        halign          number(10)              DEFAULT '0'     NOT NULL,
        style           number(10)              DEFAULT '0'     NOT NULL,
        url             varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (screenitemid)
);

insert into screens_items_tmp select * from screens_items;
drop trigger screens_items_trigger;
drop sequence screens_items_screenid;
drop table screens_items;
alter table screens_items_tmp rename to screens_items;
CREATE TABLE screens_tmp (
	screenid	number(20)	DEFAULT '0'		NOT NULL,
	name		varchar2(255)	DEFAULT 'Screen',
	hsize		number(10)	DEFAULT '1'		NOT NULL,
	vsize		number(10)	DEFAULT '1'		NOT NULL,
	PRIMARY KEY (screenid)
);

insert into screens_tmp select * from screens;
drop trigger screens_trigger;
drop sequence screens_screenid;
drop table screens;
alter table screens_tmp rename to screens;
CREATE TABLE service_alarms_tmp (
	servicealarmid	number(20)	DEFAULT '0'	NOT NULL,
	serviceid	number(20)	DEFAULT '0'	NOT NULL,
	clock		number(10)	DEFAULT '0'	NOT NULL,
	value		number(10)	DEFAULT '0'	NOT NULL,
	PRIMARY KEY (servicealarmid)
);
CREATE INDEX service_alarms_1 on service_alarms_tmp (serviceid,clock);
CREATE INDEX service_alarms_2 on service_alarms_tmp (clock);

insert into service_alarms_tmp select * from service_alarms;
drop trigger service_alarms_trigger;
drop sequence service_alarms_servicealarmid;
drop table service_alarms;
alter table service_alarms_tmp rename to service_alarms;
CREATE TABLE services_links_tmp (
	linkid		number(20)	DEFAULT '0'	NOT NULL,
	serviceupid	number(20)	DEFAULT '0'	NOT NULL,
	servicedownid	number(20)	DEFAULT '0'	NOT NULL,
	soft		number(10)	DEFAULT '0'	NOT NULL,
	PRIMARY KEY (linkid)
);
CREATE INDEX services_links_links_1 on services_links_tmp (servicedownid);
CREATE UNIQUE INDEX services_links_links_2 on services_links_tmp (serviceupid,servicedownid);

insert into services_links_tmp select * from services_links;
drop trigger services_links_trigger;
drop sequence services_links_linkid;
drop table services_links;
alter table services_links_tmp rename to services_links;
CREATE TABLE services_tmp (
        serviceid               number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(128)           DEFAULT ''      ,
        status          number(10)              DEFAULT '0'     NOT NULL,
        algorithm               number(10)              DEFAULT '0'     NOT NULL,
        triggerid               number(20)                      ,
        showsla         number(10)              DEFAULT '0'     NOT NULL,
        goodsla         number(5,2)             DEFAULT '99.9'  NOT NULL,
        sortorder               number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (serviceid)
);

insert into services_tmp select * from services;
drop trigger services_trigger;
drop sequence services_serviceid;
drop table services;
alter table services_tmp rename to services;
CREATE TABLE services_times (
	timeid		number(20)	DEFAULT '0'	NOT NULL,
	serviceid	number(20)	DEFAULT '0'	NOT NULL,
	type		number(10)	DEFAULT '0'	NOT NULL,
	ts_from		number(10)	DEFAULT '0'	NOT NULL,
	ts_to		number(10)	DEFAULT '0'	NOT NULL,
	note		varchar2(255)	DEFAULT '',
	PRIMARY KEY (timeid)
);
CREATE INDEX services_times_times_1 on services_times (serviceid,type,ts_from,ts_to);
CREATE TABLE sessions_tmp (
	sessionid	varchar2(32)	DEFAULT '',
	userid		number(20)	DEFAULT '0'	NOT NULL,
	lastaccess	number(10)	DEFAULT '0'	NOT NULL,
	PRIMARY KEY (sessionid)
);

insert into sessions_tmp select * from sessions;
drop table sessions;
alter table sessions_tmp rename to sessions;
CREATE TABLE slideshows (
        slideshowid             number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(255)           DEFAULT ''      ,
        delay           number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (slideshowid)
);
CREATE TABLE slides (
	slideid		number(20)	DEFAULT '0'	NOT NULL,
	slideshowid	number(20)	DEFAULT '0'	NOT NULL,
	screenid	number(20)	DEFAULT '0'	NOT NULL,
	step		number(10)	DEFAULT '0'	NOT NULL,
	delay		number(10)	DEFAULT '0'	NOT NULL,
	PRIMARY KEY (slideid)
);
CREATE INDEX slides_slides_1 on slides (slideshowid);
CREATE TABLE sysmaps_elements_tmp (
        selementid              number(20)              DEFAULT '0'     NOT NULL,
        sysmapid                number(20)              DEFAULT '0'     NOT NULL,
        elementid               number(20)              DEFAULT '0'     NOT NULL,
        elementtype             number(10)              DEFAULT '0'     NOT NULL,
        iconid_off              number(20)              DEFAULT '0'     NOT NULL,
        iconid_on               number(20)              DEFAULT '0'     NOT NULL,
        iconid_unknown          number(20)              DEFAULT '0'     NOT NULL,
        label           varchar2(128)           DEFAULT ''      ,
        label_location          number(10)                      NULL,
        x               number(10)              DEFAULT '0'     NOT NULL,
        y               number(10)              DEFAULT '0'     NOT NULL,
        url             varchar2(255)           DEFAULT ''      ,
        PRIMARY KEY (selementid)
);

insert into sysmaps_elements_tmp select s.selementid,s.sysmapid,s.elementid,s.elementtype,i1.imageid,i2.imageid,i1.imageid,s.label,s.label_location,s.x,s.y,s.url from sysmaps_elements s,images i1,images i2 where s.icon=i1.name and s.icon_on=i2.name;
drop trigger sysmaps_elements_trigger;
drop sequence sysmaps_elements_selementid;
drop table sysmaps_elements;
alter table sysmaps_elements_tmp rename to sysmaps_elements;
CREATE TABLE sysmaps_links_tmp (
        linkid          number(20)              DEFAULT '0'     NOT NULL,
        sysmapid                number(20)              DEFAULT '0'     NOT NULL,
        selementid1             number(20)              DEFAULT '0'     NOT NULL,
        selementid2             number(20)              DEFAULT '0'     NOT NULL,
        triggerid               number(20)                      ,
        drawtype_off            number(10)              DEFAULT '0'     NOT NULL,
        color_off               varchar2(32)            DEFAULT 'Black' ,
        drawtype_on             number(10)              DEFAULT '0'     NOT NULL,
        color_on                varchar2(32)            DEFAULT 'Red'   ,
        PRIMARY KEY (linkid)
);

insert into sysmaps_links_tmp select * from sysmaps_links;
drop trigger sysmaps_links_trigger;
drop sequence sysmaps_links_linkid;
drop table sysmaps_links;
alter table sysmaps_links_tmp rename to sysmaps_links;
CREATE TABLE sysmaps_tmp (
        sysmapid                number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(128)           DEFAULT ''      ,
        width           number(10)              DEFAULT '0'     NOT NULL,
        height          number(10)              DEFAULT '0'     NOT NULL,
        backgroundid            number(20)              DEFAULT '0'     NOT NULL,
        label_type              number(10)              DEFAULT '0'     NOT NULL,
        label_location          number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (sysmapid)
);
CREATE INDEX sysmaps_1 on sysmaps_tmp (name);

insert into sysmaps_tmp select s.sysmapid,s.name,s.width,s.height,i.imageid,s.label_type,s.label_location from sysmaps s,images i where s.background=i.name;
insert into sysmaps_tmp select s.sysmapid,s.name,s.width,s.height,0,s.label_type,s.label_location from sysmaps s where s.background='';
drop trigger sysmaps_trigger;
drop sequence sysmaps_sysmapid;
drop table sysmaps;
alter table sysmaps_tmp rename to sysmaps;
CREATE TABLE trends_tmp (
        itemid          number(20)              DEFAULT '0'     NOT NULL,
        clock           number(10)              DEFAULT '0'     NOT NULL,
        num             number(10)              DEFAULT '0'     NOT NULL,
        value_min               number(20,4)            DEFAULT '0.0000'        NOT NULL,
        value_avg               number(20,4)            DEFAULT '0.0000'        NOT NULL,
        value_max               number(20,4)            DEFAULT '0.0000'        NOT NULL,
        PRIMARY KEY (itemid,clock)
);

insert into trends_tmp select * from trends;
drop table trends;
alter table trends_tmp rename to trends;
CREATE TABLE trigger_depends_tmp (
        triggerdepid            number(20)              DEFAULT '0'     NOT NULL,
        triggerid_down          number(20)              DEFAULT '0'     NOT NULL,
        triggerid_up            number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (triggerdepid)
);
CREATE INDEX trigger_depends_1 on trigger_depends_tmp (triggerid_down,triggerid_up);
CREATE INDEX trigger_depends_2 on trigger_depends_tmp (triggerid_up);

create sequence triggerdep_tmp_triggerdepid
start with 1
increment by 1
nomaxvalue;

create trigger trigger_depends_tmp_trigger
before insert on trigger_depends_tmp
for each row
begin
	select triggerdep_tmp_triggerdepid.nextval into :new.triggerdepid from dual;
end;
/

insert into trigger_depends_tmp select NULL,triggerid_down,triggerid_up from trigger_depends;
drop trigger trigger_depends_tmp_trigger;
drop sequence triggerdep_tmp_triggerdepid;
drop table trigger_depends;
alter table trigger_depends_tmp rename to trigger_depends;
CREATE TABLE triggers_tmp (
        triggerid               number(20)              DEFAULT '0'     NOT NULL,
        expression              varchar2(255)           DEFAULT ''      ,
        description             varchar2(255)           DEFAULT ''      ,
        url             varchar2(255)           DEFAULT ''      ,
        status          number(10)              DEFAULT '0'     NOT NULL,
        value           number(10)              DEFAULT '0'     NOT NULL,
        priority                number(10)              DEFAULT '0'     NOT NULL,
        lastchange              number(10)              DEFAULT '0'     NOT NULL,
        dep_level               number(10)              DEFAULT '0'     NOT NULL,
        comments                varchar2(2048)                  ,
        error           varchar2(128)           DEFAULT ''      ,
        templateid              number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (triggerid)
);
CREATE INDEX triggers_1 on triggers_tmp (status);
CREATE INDEX triggers_2 on triggers_tmp (value);

insert into triggers_tmp select * from triggers;
drop trigger triggers_trigger;
drop sequence triggers_triggerid;
drop table triggers;
alter table triggers_tmp rename to triggers;
CREATE TABLE users_groups_tmp (
        id              number(20)              DEFAULT '0'     NOT NULL,
        usrgrpid                number(20)              DEFAULT '0'     NOT NULL,
        userid          number(20)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (id)
);
CREATE INDEX users_groups_1 on users_groups_tmp (usrgrpid,userid);

create sequence users_groups_tmp_id
start with 1
increment by 1
nomaxvalue;

create trigger users_groups_tmp_trigger
before insert on users_groups_tmp
for each row
begin
	select users_groups_tmp_id.nextval into :new.id from dual;
end;
/

insert into users_groups_tmp select NULL,usrgrpid,userid from users_groups;
drop trigger users_groups_tmp_trigger;
drop sequence users_groups_tmp_id;
drop table users_groups;
alter table users_groups_tmp rename to users_groups;
CREATE TABLE users_tmp (
        userid          number(20)              DEFAULT '0'     NOT NULL,
        alias           varchar2(100)           DEFAULT ''      ,
        name            varchar2(100)           DEFAULT ''      ,
        surname         varchar2(100)           DEFAULT ''      ,
        passwd          varchar2(32)            DEFAULT ''      ,
        url             varchar2(255)           DEFAULT ''      ,
        autologout              number(10)              DEFAULT '900'   NOT NULL,
        lang            varchar2(5)             DEFAULT 'en_gb' ,
        refresh         number(10)              DEFAULT '30'    NOT NULL,
        type            number(10)              DEFAULT '0'     NOT NULL,
        PRIMARY KEY (userid)
);
CREATE INDEX users_1 on users_tmp (alias);

insert into users_tmp select userid,alias,name,surname,passwd,url,autologout,lang,refresh,1 from users;
update users_tmp set type=3 where alias='Admin';
drop trigger users_trigger;
drop sequence users_userid;
drop table users;
alter table users_tmp rename to users;
CREATE TABLE usrgrp_tmp (
        usrgrpid                number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT ''      ,
        PRIMARY KEY (usrgrpid)
);
CREATE INDEX usrgrp_1 on usrgrp_tmp (name);

insert into usrgrp_tmp select * from usrgrp;
drop trigger usrgrp_trigger;
drop sequence usrgrp_usrgrpid;
drop table usrgrp;
alter table usrgrp_tmp rename to usrgrp;
CREATE TABLE valuemaps_tmp (
        valuemapid              number(20)              DEFAULT '0'     NOT NULL,
        name            varchar2(64)            DEFAULT ''      ,
        PRIMARY KEY (valuemapid)
);
CREATE INDEX valuemaps_1 on valuemaps_tmp (name);

insert into valuemaps_tmp select * from valuemaps;
drop trigger valuemaps_trigger;
drop sequence valuemaps_valuemapid;
drop table valuemaps;
alter table valuemaps_tmp rename to valuemaps;
