package Zaptel::Span;
#
# Written by Oron Peled <oron@actcom.co.il>
# Copyright (C) 2007, Xorcom
# This program is free software; you can redistribute and/or
# modify it under the same terms as Perl itself.
#
#use strict;
use Zaptel::Chans;

my $proc_base = "/proc/zaptel";

sub chans($) {
	my $span = shift;
	return @{$span->{CHANS}};
}

# Accessors (miniperl does not have Class:Accessor)
sub AUTOLOAD {
	my $self = shift;
	my $name = uc($AUTOLOAD);
	$name =~ s/.*://;   # strip fully-qualified portion
	if (@_) {
		return $self->{$name} = shift;
	} else {
		return $self->{$name};
	}
}

sub new($$) {
	my $pack = shift or die "Wasn't called as a class method\n";
	my $num = shift or die "Missing a span number parameter\n";
	my $self = { NUM => $num };
	bless $self, $pack;
	open(F, "$proc_base/$num") or die "Failed to open '$proc_base/$num\n";
	my $head = <F>;
	chomp $head;
	($self->{NAME}, $self->{DESCRIPTION}) = (split(/\s+/, $head, 4))[2, 3];
	$self->{CHANS} = [];
	while(<F>) {
		chomp;
		s/^\s*//;
		s/\s*$//;
		next unless /\S/;
		my ($chan, $name, $info) = split(/\s+/, $_, 3);
		my $c = Zaptel::Chans->new($self, $chan, $name, $info);
		push(@{$self->{CHANS}}, $c);
	}
	close F;
	return $self;
}

1;
