var ZarafaDnD = {
	//for future ref: a way to get the document:: evt.target.ownerDocument
	init: function(evt){
		ZarafaDnD.registerDragDropHandler();
	},
	registerDragDropHandler: function() {
		// register drag drop handler
		if(/Firefox[\/\s](\d+\.\d+)/.test(navigator.userAgent)) { //test for Firefox/x.x or Firefox x.x (ignoring remaining digits);
			if(RegExp.$1 >= 3.5) {
				// FF 3.5 uses drop event listener instead of dragdrop
				window.addEventListener("drop", ZarafaDnD.dragDropHandler, true);
			} else {
				window.addEventListener("dragdrop", ZarafaDnD.dragDropHandler, true);
			}
		}
	},
	getDnDInfo: function(){
		if(typeof window.content.wrappedJSObject.getDnDinfo == "function"){
			var dndinfo = window.content.wrappedJSObject.getDnDinfo();
			if(dndinfo.url && dndinfo.dialog_attachments){
				return dndinfo;
			}else{
				return false;
			}
		}else{
			return false;
		}
	},
	dragDropHandler: function (evt){
		var dndinfo = ZarafaDnD.getDnDInfo();
		if(dndinfo){
			// Since the event is handled, prevent it from going to a higher-level event handler.
			evt.stopPropagation();

			var fileData = ZarafaDnD.getFileData();
			if(fileData.length > 0){
				ZarafaDnD.uploadFiles(dndinfo, fileData);
			}
		}
	},

	requestDone: function(http_request2) {
		if (http_request.readyState == 4) {
			if (http_request.status == 200) {
				if(typeof window.content.wrappedJSObject.setDnDAttachments == "function"){
					var dndinfo = window.content.wrappedJSObject.setDnDAttachments(http_request.responseText);
				}
			}
		}
	},

	uploadFiles: function(dndinfo, buffer){
		var url = dndinfo.url;

		// request more permissions
		try {
			netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
		} catch (e) {
			alert("Permission to read file was denied.");
		}

		http_request = false;
		http_request = new XMLHttpRequest();
		if (!http_request) {
			alert('Cannot create XMLHTTP instance');
			return false;
		}

		// prepare the MIME POST data
		var boundaryString = 'zarafadnd';
		var boundary = '--' + boundaryString;
		var requestbody = boundary + '\n' 
		+ 'Content-Disposition: form-data; name="dialog_attachments"' + '\n' 
		+ '\n' 
		+ dndinfo.dialog_attachments 
		+ '\n' 
		+ boundary + '\n';

		for(var i=0;i<buffer.length;i++){
			requestbody
			// Change in future to multiple files
			+= 'Content-Disposition: form-data; name="attachments[]"; filename="' 
				+ buffer[i].path + '"' + '\n' 
			+ 'Content-Type: application/octet-stream' + '\n' 
			//+ 'Content-Transfer-Encoding: 8bit' + '\n' 
			+ '\n'
			+ buffer[i].binary.readBytes(buffer[i].binary.available())
			+ '\n'
			+ boundary;

			// Add \n after boundary except for the last one
			if(i != buffer.length-1){
				requestbody += '\n';
			} else {
				requestbody += '--\n';
			}
		}

		// do the AJAX request
		http_request.onreadystatechange = function(){
			ZarafaDnD.requestDone(http_request);
		}
		http_request.open('POST', url, true);
		http_request.setRequestHeader("Content-type", "multipart/form-data; \
			boundary=\"" + boundaryString + "\"");
		http_request.setRequestHeader("Connection", "close");
		http_request.setRequestHeader("Content-length", requestbody.length);
		// Use sendAsBinary because the file is added as binary
		http_request.sendAsBinary(requestbody);
	},


	getFileData: function(){
		var fileData = new Array();

		netscape.security.PrivilegeManager.enablePrivilege('UniversalXPConnect');

		var dragService =
		Components.classes["@mozilla.org/widget/dragservice;1"]
			.getService(Components.interfaces.nsIDragService);

		// Load in the currently-executing Drag/drop session.
		var dragSession = dragService.getCurrentSession();

		// Create an instance of an nsITransferable object using reflection.
		var transferObject =
		Components.classes["@mozilla.org/widget/transferable;1"]
			.createInstance();

		// Bind the object explicitly to the nsITransferable interface. We need to do this to ensure that
		// methods and properties are present and work as expected later on.
		transferObject = transferObject.QueryInterface(Components.interfaces.nsITransferable);

		transferObject.addDataFlavor("application/x-moz-file");

		// Get the number of items currently being dropped in this drag/drop operation.
		var numItems = dragSession.numDropItems;

		// Request the 'file read' privilege. We need to do this in order to be able to set the value of
		// a FileInput box. If we don't do this, we'll get a security exception when we try to set that
		// value.
		netscape.security.PrivilegeManager.enablePrivilege('UniversalFileRead');

		for (var i = 0; i < numItems; i++)
		{
			// Get the data for the given drag item from the drag session into our prepared
			// Transfer object.
			dragSession.getData(transferObject, i);

			// We need to pass in Javascript 'Object's to any XPConnect method which
			// requires OUT parameters. The out value will then be saved as a new
			// property called Object.value.
			var dataObj = new Object();
			var dropSizeObj = new Object();

			// Get the Mozilla File data type from the ITransferable object.
			transferObject.getTransferData("application/x-moz-file", dataObj, dropSizeObj);

			// Cast the returned data object as an nsIFile so that we can retrieve it's filename.
			var droppedFile = dataObj.value.QueryInterface(Components.interfaces.nsIFile);

			// Get binary data of the file
			stream = Components.classes["@mozilla.org/network/file-input-stream;1"]
				.createInstance(Components.interfaces.nsIFileInputStream);
			stream.init(droppedFile,	0x01, 00004, null);
			var bstream =  Components.classes["@mozilla.org/network/buffered-input-stream;1"]
				.getService();
			bstream.QueryInterface(Components.interfaces.nsIBufferedInputStream);
			bstream.init(stream, 1000);
			bstream.QueryInterface(Components.interfaces.nsIInputStream);
			binary = Components.classes["@mozilla.org/binaryinputstream;1"]
				.createInstance(Components.interfaces.nsIBinaryInputStream);
			binary.setInputStream (stream);

			fileData.push({
				binary: binary,
				path: droppedFile.path
			});

		}
		return fileData;
	}
};

window.addEventListener("ZarafaDnD", ZarafaDnD.init, false, true);