/*
 * Zaz
 * Copyright (C) Remigiusz Dybka 2009 <remigiusz.dybka@gmail.com>
 *
 Zaz is free software: you can redistribute it and/or modify it
 under the terms of the GNU General Public License as published by the
 Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 Zaz is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along
 with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __MENU_H__
#define __MENU_H__

#include "common.h"
#include "frame_events.h"
#include <vector>
#include <string>
#include <sstream>

#define RENDERZHEIGHT 5

class MenuItem
{
        friend class Menu;

    public:
        float x;
        float y;
        float width;
        float height;
        bool hover;

        MenuItem()
                :hover(false) {};
        virtual void Render() = 0;
        virtual void Click(float x, float y) = 0;
};

class GenericMenuItem : public MenuItem
{
        void (*func)(void *);
        void *ptr;
    protected:
        std::string text;

    public:
        GenericMenuItem(const std::string txt, void (*func)(void *) = NULL, void *ptr = NULL)
                : func(func), ptr(ptr), text(txt) {};

        virtual void Click(float x, float y)
        {
            hover=false;
            if (func != NULL)
                func(ptr);
        };

        virtual void Render();
};

class BooleanMenuItem : public GenericMenuItem
{
        Scenes::Settings *settings;
        std::string option;
        bool value;

    public:
        BooleanMenuItem(const std::string txt, Scenes::Settings *settings, const std::string option)
                : GenericMenuItem(txt),
                settings(settings), option(option), value(settings->getb(option, false)) {};

        void Click(float x, float y)
        {
            value = !value;
            settings->setb(option, value);
        };

        void Render();
};

class OptionMenuItem : public GenericMenuItem
{
        Scenes::Settings *settings;
        std::string option;
        std::vector<std::string>values;
        uint v;
        int GetVNum();

    public:
        OptionMenuItem(const std::string txt, 	std::vector<std::string>values, Scenes::Settings *settings, const std::string option)
                : GenericMenuItem(txt),
                settings(settings), option(option),
                values(values), v(GetVNum()) {};



        void Click(float x, float y)
        {
            v++;
            if (v >= values.size())
                v = 0;

            settings->set(option, values[v]);
        };

        void Render();
};

class ValueMenuItem : public GenericMenuItem
{
        Scenes::Settings *settings;
        std::string option;
        int value;
        int minimum;
        int maximum;

    public:
        ValueMenuItem(const std::string txt, int minimum, int maximum, Scenes::Settings *settings, const std::string option)
                : GenericMenuItem(txt),
                settings(settings), option(option), value(atoi(settings->get(option, "").c_str())),
                minimum(minimum), maximum(maximum) {};

        void Click(float x, float y);

        void Render();
};

class Menu
{
        float x;
        float y;
        float width;
        const static int itemHeight = 5;

        bool posCalculated;

    public:
        std::vector<MenuItem *>items;
        int lastClickedItem;
        Menu();
        ~Menu();
        Menu(float x, float y, float width);
        void SetDimensions(float x, float y, float width);
        void Add(MenuItem *item)
        {
            items.push_back(item);
            CalculatePositions();
        };

        void Add(const std::string txt);
        void Render();
        void Logic(double mx, double my, bool click);
        void CalculatePositions();
};

#endif //__MENU_H__
