param.relogit <- function(object, num, x, bootstrap = FALSE, bootfn = NULL, ...) {
  tau <- eval(object$call$tau, sys.parent())
  if (length(tau) == 2) { # without full population information
    pping <- function(object, x, x1, num, bootstrap, bootfn,...) {
      if(!bootstrap) {
        par0 <- param.default(object$lower.estimate, num=num, bootstrap=bootstrap)
        par1 <- param.default(object$upper.estimate, num=num, bootstrap=bootstrap)
      }
      else {
        dta <- eval(object$data, sys.parent())
        dta <- dta[complete.cases(model.frame(object, dta)),]
        if (is.null(bootfn)) {
          bootfn <- function(data, i, obj) {
            d <- data[i,]
            obj$call$data <- d
            fit <- eval(obj$call, sys.parent())
            return(fit$coefficients)
          }
        }
        res0 <- boot(dta, bootfn, R=num, obj = object$lower.estimate, ...)
        res1 <- boot(dta, bootfn, R=num, obj = object$upper.estimate, ...)
        colnames(res0$t) <- names(res0$t0)
        colnames(res1$t) <- names(res1$t0)
        par0 <- res0$t
        par1 <- res1$t
      }
      sim00 <- qi.glm(object$lower.estimate, par0, x = x)
      P00 <- as.matrix(sim00$qi$ev)
      sim10 <- qi.glm(object$upper.estimate, par1, x = x)
      P10 <- as.matrix(sim10$qi$ev)
      test <- P00[,1] < P10[,1]
      par0 <- as.matrix(par0[test,])
      par1 <- as.matrix(par1[test,])
      list(par0 = par0, par1 = par1)
    }
    tmp <- pping(object, bootstrap=bootstrap, bootfn=bootfn, x=x, x1=x1, num=num, ...)
    par0 <- tmp$par0
    par1 <- tmp$par1
    while (nrow(par0) < num) {
      tmp <- pping(object, bootstrap=bootstrap, bootfn=bootfn, x=x, x1=x1, num=num,...)
      par0 <- rbind(par0, tmp$par0)
      par1 <- rbind(par1, tmp$par1)
    }
    if (nrow(par0) > num) {
      par0 <- par0[1:num,]
      par1 <- par1[1:num,]
    }
    par0 <- as.matrix(par0)
    par1 <- as.matrix(par1)
    rownames(par0) <- 1:nrow(par0)
    rownames(par1) <- 1:nrow(par1)
    return(list(par0 = par0, par1 = par1))
  }
  else { # with precise population info, or no population info
    if (!bootstrap) 
      simpar <- param.default(object, num=num, bootstrap = bootstrap)
    else {
      tt <- terms(object)
      dta <- eval(object$data, sys.parent())
      dta <- dta[complete.cases(model.frame(tt, dta)),]
      if(is.null(bootfn)) {
        bootfn <- function(data, i, object) {
          d <- data[i,]
          object$call$data <- d
          fit <- eval(object$call, sys.parent())
          return(param(fit, bootstrap = TRUE))
        }
      }
      res <- boot(dta, bootfn, R = num, object = object, ...)
      colnames(res$t) <- names(res$t0)
      simpar <- res$t
    }        
    return(simpar)
  }
}
























































