print.summary.zelig<-function(object, digits=getOption("digits"),
                              print.x=FALSE, ...){
  cat("\n  Model:", object$zelig, "\n")
  if (!is.null(object$num))
      cat("  Number of simulations:", object$num, "\n")
  if (!is.null(object$x)) {
    if (print.x || nrow(object$x) == 1 || is.null(dim(object$x))) {
      if (class(object$x) == "setx.cond")
        cat("\nObserved Data \n")
      else
        cat("\nValues of X \n")
      print.setx(object$x, digits=digits, ...)
      if(!is.null(object$x1)){
        cat("\nValues of X1 \n")
        print.setx(object$x1, digits=digits, ...)
      }
    }
    else {
      if (class(object$x) == "setx.cond")
        cat("\nMean Values of Observed Data (n = ", nrow(object$x), ") \n", sep = "")
      else
        cat("\nMean Values of X (n = ", nrow(object$x), ") \n", sep = "")
      print.setx(apply(object$x, 2, mean), digits=digits, ...)
      if (!is.null(object$x1)) {
        cat("\nMean Values of X1 (n = ", nrow(object$x1), ") \n", sep = "")
        print.setx(apply(object$x1, 2, mean), digits=digits, ...) 
      }
    }
  }
  for (i in 1:length(object$qi.name)){
    indx <- pmatch(names(object$qi.name[i]), names(object$qi.stats))
    tmp <- object$qi.stats[[indx]]
    if (names(object$qi.name)[indx] == "pr" && colnames(tmp)[1] != "mean")
      lab <- paste(object$qi.name[[i]], "(percentage of simulations)", sep = " ")
    else
      lab <- object$qi.name[[i]]
    cat("\n", lab, "\n", sep = "")
    if (length(dim(tmp)) == 3) {
        for (j in 1:dim(tmp)[3]){
          cat("\n  Observation", dimnames(tmp)[[3]][j], "\n")
          if (is.null(rownames(tmp[,,j])))
            rownames(tmp[,,j]) <- 1:nrow(tmp[,,j])
          if (!is.null(names(tmp[,,j])))
            names(tmp[,,j]) <- NULL
          print.matrix(tmp[,,j], digits=digits, ...)
        }
      }
    else {
      if (is.null(rownames(tmp)))
        rownames(tmp) <- 1:nrow(tmp)
      if (!is.null(names(tmp)))
        names(tmp) <- NULL
      print.matrix(tmp, digits=digits, ...)
    }
  }
}












