qi.lm <- function(object, par, x, x1 = NULL, y = NULL) {
  k <- length(object$coef)
  coef <- par[,1:k]
  alpha <- par[,(k+1):ncol(par)]
  ev <- coef %*% t(x)
  pr <- matrix(NA, nrow = nrow(ev), ncol = ncol(ev))
  dimnames(pr) <- dimnames(ev) 
  for (i in 1:nrow(pr)) 
    pr[i,] <- rnorm(length(ev[i,]), mean = ev[i,], sd = alpha[i])
  qi <- list(ev=ev, pr=pr)
  qi.name <- list(ev="Expected Values: E(Y|X)",
                  pr = "Predicted Values: Y|X")
  if(!is.null(x1)){
    ev1 <- coef %*% t(x1)
    qi$fd <- ev1-ev
    qi.name$fd <-
      "First Differences in Expected Values: E(Y|X1)-E(Y|X)"
  }
  if (!is.null(y)) {
    yvar <- matrix(rep(y, nrow(par)), nrow = nrow(par), byrow = TRUE)
    tmp.ev <- yvar - qi$ev
    tmp.pr <- yvar - qi$pr
    qi$ate.ev <- matrix(apply(tmp.ev, 1, mean), nrow = nrow(par))
    qi$ate.pr <- matrix(apply(tmp.pr, 1, mean), nrow = nrow(par))
    qi.name$ate.ev <- "Average Treatment Effect: Y - EV"
    qi.name$ate.pr <- "Average Treatment Effect: Y - PR"
  }
  list(qi=qi, qi.name=qi.name)
}



