<?php

require_once 'Zend/Tool/Project/Provider/Abstract.php';


class Zend_Tool_Project_Provider_View extends Zend_Tool_Project_Provider_Abstract
{
    
    public static function createResource(Zend_Tool_Project_Profile $profile, $controllerName, $actionName, $moduleName = null)
    {
        if (!is_string($controllerName)) {
            throw new Zend_Tool_Project_Provider_Exception('Zend_Tool_Project_Provider_View::createResource() expects \"controllerName\" is the name of a controller resource to create.');
        }
        
        if (!is_string($actionName)) {
            throw new Zend_Tool_Project_Provider_Exception('Zend_Tool_Project_Provider_View::createResource() expects \"actionName\" is the name of a controller resource to create.');
        }
        
        $profileSearchParams = array();
        
        if ($moduleName) {
            $profileSearchParams = array('modulesDirectory', 'moduleDirectory' => $moduleName);
        }
        
        $profileSearchParams[] = 'viewsDirectory';
        $profileSearchParams[] = 'viewScriptsDirectory';

        if (($viewScriptsDirectory = $profile->search($profileSearchParams)) === false) {
            require_once 'Zend/Tool/Project/Provider/Exception.php';
            throw new Zend_Tool_Project_Provider_Exception('This project does not have a viewScriptsDirectory resource.');
        }
        
        $profileSearchParams['viewControllerScriptsDirectory'] = array('forControllerName' => $controllerName);
        
        if (($viewControllerScriptsDirectory = $viewScriptsDirectory->search($profileSearchParams)) === false) {
            $viewControllerScriptsDirectory = $viewScriptsDirectory->createResource('viewControllerScriptsDirectory', array('forControllerName' => $controllerName));
        }
        
        $newViewScriptFile = $viewControllerScriptsDirectory->createResource('ViewScriptFile', array('forActionName' => $actionName));

        return $newViewScriptFile;
    }

    public function create($controllerName, $actionName)
    {
        
        
        /*
        $profile = $this->_getExistingProfile();
        $viewScriptsDirectoryNode = $profile->findNodeByContext(array(
            'viewsDirectory', 'viewScriptsDirectory'
        ));

        $registry = Zend_Tool_Project_Context_Registry::getInstance();

        $newViewControllerScriptsDirectoryContext = $registry->getContext('ViewControllerScriptsDirectory');
        $newViewControllerScriptsDirectoryContext->setForControllerName($controllerName);

        $newViewScriptFileContext = $registry->getContext('ViewScriptFile');
        $newViewScriptFileContext->setScriptName($actionName);


        $newViewControllerScriptsDirectoryNode = new Zend_Tool_Project_Resource($newViewControllerScriptsDirectoryContext);
        $newViewScriptFileNode = new Zend_Tool_Project_Resource($newViewScriptFileContext);

        $newViewControllerScriptsDirectoryNode->append($newViewScriptFileNode);
        $newViewControllerScriptsDirectoryNode->recursivelySetBaseDirectory($viewScriptsDirectoryNode->getPath());
        $newViewControllerScriptsDirectoryNode->recursivelyCreate();

        $viewScriptsDirectoryNode->append($newViewControllerScriptsDirectoryNode);

        Zend_Tool_Framework_Client_Registry::getInstance()->response->appendContent(
            'Creating a view script.'
        );

        $this->_storeLoadedProfile();
        */
    }
}