/*
 * Decompiled with CFR 0.152.
 */
package IceBox;

import Ice.Application;
import Ice.ObjectPrx;
import Ice.Properties;
import IceBox.ServiceManagerPrx;
import IceBox.ServiceManagerPrxHelper;
import java.util.ArrayList;

public final class Admin {
    public static void main(String[] args) {
        Client app = new Client();
        int rc = app.main("IceBox.Admin", args);
        System.exit(rc);
    }

    private static class Client
    extends Application {
        private Client() {
        }

        private void usage() {
            System.err.println("Usage: " + Client.appName() + " [options] [command...]\n" + "Options:\n" + "-h, --help          Show this message.\n" + "\n" + "Commands:\n" + "shutdown            Shutdown the server.");
        }

        public int run(String[] args) {
            String managerProxy;
            ArrayList<String> commands = new ArrayList<String>();
            for (int idx = 0; idx < args.length; ++idx) {
                if (args[idx].equals("-h") || args[idx].equals("--help")) {
                    this.usage();
                    return 1;
                }
                if (args[idx].charAt(0) == '-') {
                    System.err.println(Client.appName() + ": unknown option `" + args[idx] + "'");
                    this.usage();
                    return 1;
                }
                commands.add(args[idx]);
            }
            if (commands.isEmpty()) {
                this.usage();
                return 0;
            }
            Properties properties = Client.communicator().getProperties();
            String managerIdentity = properties.getProperty("IceBox.ServiceManager.Identity");
            if (managerIdentity.length() == 0) {
                managerIdentity = properties.getPropertyWithDefault("IceBox.InstanceName", "IceBox") + "/ServiceManager";
            }
            if (properties.getProperty("Ice.Default.Locator").length() == 0) {
                String managerEndpoints = properties.getProperty("IceBox.ServiceManager.Endpoints");
                if (managerEndpoints.length() == 0) {
                    System.err.println(Client.appName() + ": property `IceBox.ServiceManager.Endpoints' is not set");
                    return 1;
                }
                managerProxy = managerIdentity + ":" + managerEndpoints;
            } else {
                String managerAdapterId = properties.getProperty("IceBox.ServiceManager.AdapterId");
                if (managerAdapterId.length() == 0) {
                    System.err.println(Client.appName() + ": property `IceBox.ServiceManager.AdapterId' is not set");
                    return 1;
                }
                managerProxy = managerIdentity + ":" + managerAdapterId;
            }
            ObjectPrx base = Client.communicator().stringToProxy(managerProxy);
            ServiceManagerPrx manager = ServiceManagerPrxHelper.checkedCast(base);
            if (manager == null) {
                System.err.println(Client.appName() + ": `" + managerProxy + "' is not running");
                return 1;
            }
            for (int i = 0; i < commands.size(); ++i) {
                String command = (String)commands.get(i);
                if (!command.equals("shutdown")) {
                    System.err.println(Client.appName() + ": unknown command `" + command + "'");
                    this.usage();
                    return 1;
                }
                manager.shutdown();
            }
            return 0;
        }
    }
}

