/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.NoEndpointException;
import Ice.ObjectAdapter;
import Ice.ObjectPrx;
import Ice.RouterPrx;
import Ice.RoutingTable;

public final class RouterInfo {
    private final RouterPrx _router;
    private ObjectPrx _clientProxy;
    private ObjectPrx _serverProxy;
    private final RoutingTable _routingTable;
    private ObjectAdapter _adapter;
    static final /* synthetic */ boolean $assertionsDisabled;

    RouterInfo(RouterPrx router) {
        this._router = router;
        this._routingTable = new RoutingTable();
        if (!$assertionsDisabled && this._router == null) {
            throw new AssertionError();
        }
    }

    public synchronized void destroy() {
        this._clientProxy = null;
        this._serverProxy = null;
        this._adapter = null;
        this._routingTable.clear();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RouterInfo) {
            return this._router.equals(((RouterInfo)obj)._router);
        }
        return false;
    }

    public RouterPrx getRouter() {
        return this._router;
    }

    public synchronized ObjectPrx getClientProxy() {
        if (this._clientProxy == null) {
            this._clientProxy = this._router.getClientProxy();
            if (this._clientProxy == null) {
                throw new NoEndpointException();
            }
            this._clientProxy = this._clientProxy.ice_router(null);
            this._clientProxy = this._clientProxy.ice_timeout(this._router.ice_connection().timeout());
        }
        return this._clientProxy;
    }

    public synchronized void setClientProxy(ObjectPrx clientProxy) {
        this._clientProxy = clientProxy.ice_router(null);
        this._clientProxy = this._clientProxy.ice_timeout(this._router.ice_connection().timeout());
    }

    public ObjectPrx getServerProxy() {
        if (this._serverProxy == null) {
            this._serverProxy = this._router.getServerProxy();
            if (this._serverProxy == null) {
                throw new NoEndpointException();
            }
            this._serverProxy = this._serverProxy.ice_router(null);
        }
        return this._serverProxy;
    }

    public void setServerProxy(ObjectPrx serverProxy) {
        this._serverProxy = serverProxy.ice_router(null);
    }

    public void addProxy(ObjectPrx proxy) {
        if (this._routingTable.add(proxy)) {
            this._router.addProxy(proxy);
        }
    }

    public synchronized void setAdapter(ObjectAdapter adapter) {
        this._adapter = adapter;
    }

    public synchronized ObjectAdapter getAdapter() {
        return this._adapter;
    }

    static {
        $assertionsDisabled = !RouterInfo.class.desiredAssertionStatus();
    }
}

