# **********************************************************************
#
# Copyright (c) 2003-2005 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

# Ice version 3.1.0
# Generated from file `IceBox.ice'

import Ice, IcePy, __builtin__
import Ice_BuiltinSequences_ice
import Ice_CommunicatorF_ice
import Ice_PropertiesF_ice
import Ice_SliceChecksumDict_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Start of module IceBox
_M_IceBox = Ice.openModule('IceBox')
__name__ = 'IceBox'

if not _M_IceBox.__dict__.has_key('FailureException'):
    _M_IceBox.FailureException = Ice.createTempClass()
    class FailureException(Ice.LocalException):
        def __init__(self, reason=''):
            self.reason = reason

        def ice_name(self):
            return 'IceBox::FailureException'

        def __str__(self):
            return IcePy.stringifyException(self)

        __repr__ = __str__

    _M_IceBox._t_FailureException = IcePy.defineException('::IceBox::FailureException', FailureException, None, (("reason", IcePy._t_string),))
    FailureException.ice_type = _M_IceBox._t_FailureException

    _M_IceBox.FailureException = FailureException
    del FailureException

if not _M_IceBox.__dict__.has_key('Service'):
    _M_IceBox.Service = Ice.createTempClass()
    class Service(Ice.LocalObject):
        def __init__(self):
            if __builtin__.type(self) == _M_IceBox.Service:
                raise RuntimeError('IceBox.Service is an abstract class')

        #
        # Operation signatures.
        #
        # def start(self, name, communicator, args):
        # def stop(self):

        def __str__(self):
            return IcePy.stringify(self, _M_IceBox._t_Service)

        __repr__ = __str__

    _M_IceBox._t_Service = IcePy.defineClass('::IceBox::Service', Service, True, None, (), ())
    Service.ice_type = _M_IceBox._t_Service

    _M_IceBox.Service = Service
    del Service

if not _M_IceBox.__dict__.has_key('ServiceManager'):
    _M_IceBox.ServiceManager = Ice.createTempClass()
    class ServiceManager(Ice.Object):
        def __init__(self):
            if __builtin__.type(self) == _M_IceBox.ServiceManager:
                raise RuntimeError('IceBox.ServiceManager is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceBox::ServiceManager')

        def ice_id(self, current=None):
            return '::IceBox::ServiceManager'

        #
        # Operation signatures.
        #
        # def getSliceChecksums(self, current=None):
        # def shutdown(self, current=None):

        def __str__(self):
            return IcePy.stringify(self, _M_IceBox._t_ServiceManager)

        __repr__ = __str__

    _M_IceBox.ServiceManagerPrx = Ice.createTempClass()
    class ServiceManagerPrx(Ice.ObjectPrx):

        def getSliceChecksums(self, _ctx=None):
            return _M_IceBox.ServiceManager._op_getSliceChecksums.invoke(self, (), _ctx)

        def shutdown(self, _ctx=None):
            return _M_IceBox.ServiceManager._op_shutdown.invoke(self, (), _ctx)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceBox.ServiceManagerPrx.ice_checkedCast(proxy, '::IceBox::ServiceManager', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=''):
            return _M_IceBox.ServiceManagerPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

    _M_IceBox._t_ServiceManagerPrx = IcePy.defineProxy('::IceBox::ServiceManager', ServiceManagerPrx)

    _M_IceBox._t_ServiceManager = IcePy.defineClass('::IceBox::ServiceManager', ServiceManager, True, None, (), ())
    ServiceManager.ice_type = _M_IceBox._t_ServiceManager

    ServiceManager._op_getSliceChecksums = IcePy.Operation('getSliceChecksums', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_SliceChecksumDict, ())
    ServiceManager._op_shutdown = IcePy.Operation('shutdown', Ice.OperationMode.Normal, False, (), (), None, ())

    _M_IceBox.ServiceManager = ServiceManager
    del ServiceManager

    _M_IceBox.ServiceManagerPrx = ServiceManagerPrx
    del ServiceManagerPrx

# End of module IceBox

Ice.sliceChecksums["::IceBox::ServiceManager"] = "bc15b3f6fb20c71362f0f6d5b32da76"
