use Test::More tests => 8;

use strict;
use Zim::TextBuffer;

my $var = "test 123\ntest 345\n";

my $f = Zim::TextBuffer->new(\$var);

ok($f->read eq "test 123\ntest 345\n", 'read 1');

is_deeply([$f->read], ["test 123\n", "test 345\n"], 'read 2');

$f->write("foo bar");
ok($var eq 'foo bar', 'write');

$f->append(' baz');
ok($var eq 'foo bar baz', 'append');

my $fh = $f->open('r');
ok(<$fh> eq 'foo bar baz', 'open r');
close $fh;

ok($f->exists, 'exists 1');

$f->remove;
ok(!defined($var), 'remove');

ok(!$f->exists, 'exists 2');

