#import "ExpectationSetTest.h"

@implementation ExpectationSetTest

- (void)testSingleUnsuccessfulExpectation {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationSet addExpectedObject:@"Hello, world!"];

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"Hello, world!\"), was ()"];
}

- (void)testSingleSucccessfulExpectation {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];

    [expectationSet addExpectedObject:@"Hello, world!"];
    [expectationSet addActualObject:@"Hello, world!"];

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER
}

- (void)testSingleExpectationDoesntMatchActual {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationSet addExpectedObject:@"I expected this!"];

    NS_DURING
        [expectationSet addActualObject:@"But got this!"];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations didn't expect But got this!"];
}

- (void)testMultipleActualsForSingleExpectation {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];

    [expectationSet addExpectedObject:@"One"];
    [expectationSet addExpectedObject:@"Two"];
    [expectationSet addActualObject:@"One"];
    [expectationSet addActualObject:@"Two"];

    NS_DURING
        [expectationSet addActualObject:@"Two"];
        [expectationSet addActualObject:@"Two"];
        [expectationSet addActualObject:@"One"];
        [expectationSet addActualObject:@"One"];
        [expectationSet verify];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER
}

- (void)testFailOnVerify {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationSet addExpectedObject:@"I expected this!"];

    [expectationSet setFailsOnVerify:YES];

    NS_DURING
        [expectationSet addActualObject:@"But got this!"];
    NS_HANDLER
        [self fail:@"Should not raise exception"];
    NS_ENDHANDLER

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"I expected this!\"), was (\"But got this!\")"];
}

- (void)testExpectSelector {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];
    NSException *exception = nil;

    [expectationSet addExpectedSelector:@selector(invoked:)];
    [expectationSet addExpectedSelector:@selector(notInvoked:)];

    [expectationSet addActualSelector:@selector(invoked:)];

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
    [self assertString:[exception name] equals:@"AssertionFailedException"];
    [self assertString:[exception reason] equals:@"My Expectations expected (\"selector -notInvoked:\", \"selector -invoked:\"), was (\"selector -invoked:\")"];
}

- (void)testVerifyPassesOnNoExpectations {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testAddActualPassesOnNoExpectations {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];

    NS_DURING
        [expectationSet addActualObject:@"Unexpected"];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

- (void)testVerifyPassesAfterAddActualOnNoExpectations {
    ExpectationSet *expectationSet = [[[ExpectationSet alloc] initWithName:@"My Expectations"] autorelease];

    [expectationSet addActualObject:@"Unexpected"];

    NS_DURING
        [expectationSet verify];
    NS_HANDLER
        [self fail:@"Shouldn't raise exception"];
    NS_ENDHANDLER
}

@end
