#!/usr/bin/awk -f
#Extracts from ziproxy logs information abut content sizes before and after
#modification. Usage: 
#stats.awk logfile

BEGIN {FS = "[, ]"}

/\] In Content-Length:/ {
		inlen[$1] = $4
		}
		
/\] +Content-Length:/ {
	if ($1 in inlen)	outlen[$1] = $5
	else inlen[$1] = $5
		}
		
/ Image = /{ 
		img[$1] = $4
		}
		

END {
		for (x in inlen)
		{
				insum+=inlen[x]
				if(img[x] > 0) imgb += inlen[x];
						
				if (x in outlen)
				{
						outsum += outlen[x]
						if (img[x] > 0)
								imga += outlen[x]
				}
						else 
						{
								outsum += inlen[x]
								if (img[x] > 0)
										imga += inlen[x]
						}
								
		}
		print "All original content:", insum
		print "All modified content:", outsum
		print "Original images:", imgb
		print "Modified images:", imga
	}
