/* cfgfile.h
 * Part of ziproxy package.
 * 
 * Copyright (c)2003-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2009 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 * 
 * Configuration file parsing functions.
 */

//To stop multiple inclusions.
#ifndef SRC_CFGFILE_H
#define SRC_CFGFILE_H

#include "qparser.h"
#include "image.h"
#include "urltables.h"
#include "simplelist.h"
#include "jp2tools.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_RESTRICTOUTPORTHTTP_LEN 16
#define MAX_RESTRICTOUTPORTCONNECT_LEN 16

extern int Port, NextPort, NetdTimeout, ZTimeout, MaxSize, PreemptNameResMax, MaxUncompressedGzipRatio, MinUncompressedGzipStreamEval, MaxUncompressedImageRatio;

extern int ImageQuality[4];
//#define ThumbQ (ImageQ[0])
//#define SmallQ (ImageQ[1])
//#define MedQ (ImageQ[2])
//#define LargeQ (ImageQ[3])

extern int RestrictOutPortHTTP [MAX_RESTRICTOUTPORTHTTP_LEN];
extern int RestrictOutPortCONNECT [MAX_RESTRICTOUTPORTCONNECT_LEN];
extern int RestrictOutPortHTTP_len;
extern int RestrictOutPortCONNECT_len;

extern t_qp_bool MSIETest, DoGzip, UseContentLength, AllowLookCh, ProcessJPG, ProcessPNG, ProcessGIF, PreemptNameRes, PreemptNameResBC, TransparentProxy, ConventionalProxy, ProcessHTML, ProcessCSS, ProcessJS, ProcessHTML_CSS, ProcessHTML_JS, ProcessHTML_tags, ProcessHTML_text, ProcessHTML_PRE, ProcessHTML_NoComments, ProcessHTML_TEXTAREA, AllowMethodCONNECT, OverrideAcceptEncoding, DecompressIncomingGzipData, WA_MSIE_FriendlyErrMsgs, AccessLogUserPOV, InterceptCrashes;

extern char *WhereZiproxy, *ServHost, *ServUrl, *OnlyFrom, *LogFileName, *NextProxy;
extern char **LogPipe, **Compressible;
extern char *CustomError400, *CustomError403, *CustomError404, *CustomError407, *CustomError408, *CustomError409, *CustomError500, *CustomError503;
extern char *Address;
extern char *AccessLogFileName;
extern char *PasswdFile;
extern char *RedefineUserAgent;
extern char *URLNoProcessing;
extern char *URLReplaceData;
extern char *URLReplaceDataCT;
extern char *URLDeny;
extern char *tmpBindOutgoingExList;
extern char *tmpBindOutgoingExAddr;
extern t_st_strtable *BindOutgoingExList;
extern in_addr_t *BindOutgoingExAddr;
extern in_addr_t *BindOutgoing;
extern int BindOutgoing_entries;

extern const t_ut_urltable *urltable_noprocessing;
extern const t_ut_urltable *urltable_replacedata;
extern const t_ut_urltable *urltable_replacedatact;
extern const t_st_strtable *urltable_replacedatactlist;
extern const t_ut_urltable *urltable_deny;
extern const t_st_strtable *passwd_table;

#ifdef JP2K
extern int JP2ImageQuality[4];
extern t_qp_bool ProcessJP2, ForceOutputNoJP2, ProcessToJP2, AnnounceJP2Capability, JP2OutRequiresExpCap;
// extern int JP2Colorspace_cfg;
extern t_color_space JP2Colorspace;    // 0=RGB 1=YUV
// extern int JP2Upsampler_cfg;
extern t_upsampler JP2Upsampler;       // upsampler method: 0-linear, 1-lanczos
extern int JP2BitResYA[8];	// 4x qualities 2 components: YA YA YA YA
extern int JP2BitResRGBA[16];	// 4x qualities 4 components: RGBA RGBA RGBA RGBA
extern int JP2BitResYUVA[16];	// 4x qualities 4 components: YUVA YUVA YUVA YUVA
extern int JP2CSamplingYA[32];	// 4x qualities 2 components 4 settings: YxYyYwYh AxAyAwAh YxYyYwYh AxAyAwAh YxYyYwYh AxAyAwAh YxYyYwYh AxAyAwAh
extern int JP2CSamplingRGBA[64];	// 4x qualities 4 components 4 settings: RxRyRwRh GxGyGwGh BxByBwBh AxAyAwAh ... (4 times)
extern int JP2CSamplingYUVA[64];	// 4x qualities 4 components 4 settings: YxYyYwYh UxUyUwUh VxVyVwVh AxAyAwAh ... (4 times)
#endif

extern int ReadCfgFile(char * cfg_file);

#ifndef DefaultCfgLocation
extern char DefaultCfgLocation[];
#endif

extern int getImageQuality (int width, int height);
#ifdef JP2K
extern const int *getJP2KBitLenYA (int width, int height);
extern const int *getJP2KBitLenRGBA (int width, int height);
extern const int *getJP2KBitLenYUVA (int width, int height);
extern const int *getJP2KCSamplingYA (int width, int height);
extern const int *getJP2KCSamplingRGBA (int width, int height);
extern const int *getJP2KCSamplingYUVA (int width, int height);
extern int getJP2ImageQuality (int width, int height);
#endif

#endif //SRC_CFGFILE_H
