/* gencvtables.h
 * Part of ziproxy package
 *
 * Copyright (c)2005-2009 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Generates precalculated tables for Ziproxy routines.
 * This is a standalone code and not included in main Ziproxy executable.
 */

#include <stdio.h>

/* convert a lower (bitwise) resolution number to a higher one */
/* inres = inval bit resolution ( < outres)
 * outres = output bit resolution
 * inval = the value to be converted */
int convert_to_higher_bitlen (int inres, int outres, int inval)
{
	int bitc;
	int outval = 0;
	int shifted_inval;

	shifted_inval = inval << (outres - inres);

	for (bitc = 0; bitc < outres; bitc += inres) {
		outval |= shifted_inval >> bitc;
	}
	return (outval);
}


void gentable_any2eight (void)
{
	int bitwidth;
	int value;
	int this_entry;
	int total_subtables = 9;

	printf ("const unsigned char table_bitres_any2eight [9][256] = { \\\n");
	for (bitwidth = 0; bitwidth < total_subtables; bitwidth++) {
		// printf ("BITWIDTH: %d\n", bitwidth);
		printf ("\t{ ");
		for (value = 0; value < 256; value++) {
			if (bitwidth == 0) {
				this_entry = 0;
			} else if (bitwidth == 8) {
				this_entry = value;
			} else {
				// crops value within bitwidth mask for aesthetic purposes (the value won't be used anyway)
				this_entry = convert_to_higher_bitlen (bitwidth, 8, value & ((1 << bitwidth) - 1));
			}
			printf ("0x%02x", this_entry);
			if (value != 255) {
				if ((value & 0x07) == 0x07)
					printf (", \\\n\t");
				else
					printf (", ");
			}

		}
		if (bitwidth < (total_subtables - 1))
			printf (" }, \\\n");
		else
			printf (" } \\\n");
	}
	printf ("\t};\n\n");
}

main ()
{
	printf ("/* cvtables.h\n"
		" * Part of ziproxy package\n"
		" * \n"
		" * Copyright (c)2005-2009 Daniel Mealha Cabrita\n"
		" *\n"
		" * Released subject to GNU General Public License v2 or later version.\n"
		" *\n"
		" * Conversion tables\n"
		" *\n"
		" * *** Do not edit this file directly, it was generated by gencvtables.c\n"
		" * *** gencvtables is not invoked neither compiled by make,\n"
	        " * *** thus it should be compiled and executed manually.\n"
		" */\n"
		"\n\n");
	printf ("//To stop multiple inclusions.\n"
		"#ifndef CVTABLES_H\n"
		"#define CVTABLES_H\n"
		"\n"
		"#define UPSAMPLE_TO_U8BIT(value,bitlen) table_bitres_any2eight [bitlen][value]\n"
		"\n");

	gentable_any2eight ();
	
	printf ("\n"
		"#endif\n"
		"\n");
}
