/* image.h
 * Part of ziproxy package
 *
 * Copyright (c)2002-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2009 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * Image reading/writing wrappers.
 */

#include "http.h"

//If this is included in image.c, make declarations local.
#ifdef SRC_IMAGE_C
#define EXTERN
#else
#define EXTERN extern
#endif 

//To stop multiple inclusions.
#ifndef SRC_IMAGE_H
#define SRC_IMAGE_H


enum {OTHER_CONTENT, IMG_PNG, IMG_GIF, IMG_JPEG, IMG_JP2K, TEXT_HTML, TEXT_CSS, APPLICATION_JAVASCRIPT};
enum enum_color_space {CENC_RGB, CENC_YUV}; // only applies to color images, irrelevant to mono (LUMA) images
#define t_color_space enum enum_color_space

#define I_PALETTE (1<<1)
#define I_TRANSPARENT (1<<2)

//In case flags contains this, look for error code?.
#define I_ERROR (1<<15)

#define IMG_UNIQUE_RET_MASK 0x0000ffff

#define IMG_RET_OK 0
#define IMG_RET_ERR_BAD_DATA_FORMAT 1
#define IMG_RET_ERR_OUT_OF_MEM 2
#define IMG_RET_ERR_UNKNOWN 3
#define IMG_RET_ERR_NOT_IMPL_YET 4
#define IMG_RET_ERR_POSSIBLE_LOOK_CHANGE 5
#define IMG_RET_TOO_SMALL 32
#define IMG_RET_ERR_OTHER 33
#define IMG_RET_TOO_EXPANSIVE 34
#define IMG_RET_FLG_WHILE_DECOMP (1<<16)
#define IMG_RET_FLG_WHILE_TRANSFORM (1<<17)
#define IMG_RET_FLG_WHILE_COMPRESS (1<<18)

/* Components of raster/palette entries are known from bpp:
 * 1 -> Grayscale (Y)
 * 2 -> Y + Alpha (255 = opaque 0 = transparent)
 * 3 -> RGB (may contain YUV version in alternate buffer)
 * 4 -> RGB (may contain YUV version in alternate buffer) + Alpha
 */

typedef struct {
	unsigned char * raster;	//For paletted images
	unsigned char * palette;
	unsigned char * bitmap;	//For grayscale/truecolor RGB images (always present and the default bitmap)
	unsigned char * bitmap_yuv; //For truecolor YUV images (allocated on demand)
	int pal_entries;
	int width, height;
	int pal_bpp, bpp;
} raw_bitmap;

//EXTERN raw_image *new_raw_image(int height, int width, int bpp, int flags);
EXTERN int detect_type(char *line, int len);

EXTERN int compress_image(http_headers *serv_hdr, http_headers *client_hdr, char *inbuf, int insize, char ** outb, int *outl);	

#endif //SRC_IMAGE_H

#undef EXTERN
