/* gzpipe.h
 * Part of ziproxy package.
 *
 * Copyright (c)2003-2004 Juraj Variny<variny@naex.sk>
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * Released subject to GNU General Public License v2 or later version.
 *
 * gzlib pipe-pipe routines
 */


//To stop multiple inclusions.
#ifndef SRC_ZPIPE_H
#define SRC_ZPIPE_H

/* Use faster (thread-unsafe) variants of getc() and putc(), if possible. */
#ifdef getc_unlockedXXXX
#define fastgetc(x) getc_unlocked(x)
#else
#define fastgetc(x) getc(x)
#endif

#ifdef putc_unlocked
#define fastputc(x,y) putc_unlocked(x,y)
#else
#define fastputc(x,y) putc(x,y)
#endif

#include "globaldefs.h"

int gzip_stream_stream (FILE *source, FILE *dest, int level, ZP_DATASIZE_TYPE *inlen, ZP_DATASIZE_TYPE *outlen, int de_chunk);
int gunzip_stream_stream (FILE *source, FILE *dest, ZP_DATASIZE_TYPE *inlen, ZP_DATASIZE_TYPE *outlen, int de_chunk, int max_ratio, ZP_DATASIZE_TYPE min_eval);
int gzip_memory_stream (const char *source, FILE *dest, int level, ZP_DATASIZE_TYPE inlen, ZP_DATASIZE_TYPE *outlen);

#endif //SRC_ZPIPE_H

