/*
 * link.c
 *
 * Copyright (C) 1993 Alain Knaff
 */
#define _LARGEFILE64_SOURCE
#define _GNU_SOURCE

#include "sysincludes.h"

int link(__const char *file_name1, __const char *file_name2)
{
  int st;
  char newname1[MAXPATHLEN + MAXEXTLEN + 1];
  char newname2[MAXPATHLEN + MAXEXTLEN + 1];


  st = zlib_real_link(file_name1, file_name2);

  if ( st >= 0 || errno != ENOENT )
    return st;

  zlib_initialise();
  if ( zlib_mode & CM_DISAB )
    return st;
  if ( (zlib_getfiletype(file_name1,-1) & PM_READ_MASK) == PM_LEAVE_COMPR)
    return st;

  
  strncpy(newname1,file_name1,1024);
  strcat(newname1,zlib_ext);
  
  strncpy(newname2,file_name2,1024);
  strcat(newname2,zlib_ext);
  
  errno = 0;
  return zlib_real_link(newname1, newname2);
}
