#! /bin/sh
output=docbook2html-dir
skip=0
for arg in $*
do
  if [ $skip -gt 0 ]
  then
    skip=$(($skip - 1))
    continue
  fi
  case $arg in
  -h|--help|-v|--version|-n|--nostd|-u|--nochunks)
				break
				;;
  -*)				skip=1
				;;
  *)	output="$(echo $arg | sed 's,\.sgml$,,;s,\.sgm$,,')"
	break
	;;
  esac
done
if [ -d ${output} ]
then
  rm -rf ${output}.junk
  mv ${output} ${output}.junk
fi
mkdir ${output}
jw -f docbook -b html -o ${output} "$@"
