/* Copyright (C) 1997, 1998 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

#ifndef _NET_L_IF_H

#define _NET_L_IF_H	1
#include <features.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <net/if.h>

struct lifaddr
  {
    __SOCKADDR_ARG lifa_addr;	/* Address of interface.  */
    union
      {
	__SOCKADDR_ARG	lifu_broadaddr;
	__SOCKADDR_ARG	lifu_dstaddr;
      } lifa_ifu;
    struct iface   *lifa_ifp;	/* Back-pointer to interface.  */
    struct lifaddr *lifa_next;	/* Next address for interface.  */
  };

#define	lifa_broadaddr	lifa_ifu.lifu_broadaddr	/* broadcast address	*/
#define	lifa_dstaddr	lifa_ifu.lifu_dstaddr	/* other end of link	*/

/* Interface request structure used for socket ioctl's.  All interface
   ioctl's must have parameter definitions which begin with ifr_name.
   The remainder may be interface specific.  */

struct lifreq
  {
#define IFHWADDRLEN	6
#define	IFNAMSIZ	16
    union
      {
	char lifrn_name[IFNAMSIZ];	/* Interface name, e.g. "en0".  */
      } lifr_ifrn;

    union
      {
	struct sockaddr lifru_addr;
	__SOCKADDR_ARG lifru_dstaddr;
	__SOCKADDR_ARG lifru_broadaddr;
	__SOCKADDR_ARG lifru_netmask;
	__SOCKADDR_ARG lifru_hwaddr;
	long lifru_flags;
	long lifru_ivalue;
	long lifru_mtu;
	struct ifmap lifru_map;
	char lifru_slave[IFNAMSIZ];	/* Just fits the size */
	__caddr_t lifru_data;
      } lifr_ifru;
  };

#define lifr_name	lifr_ifrn.lifrn_name	/* interface name 	*/
#define lifr_hwaddr	lifr_ifru.lifru_hwaddr	/* MAC address 		*/
#define	lifr_addr	lifr_ifru.lifru_addr	/* address		*/
#define	lifr_dstaddr	lifr_ifru.lifru_dstaddr	/* other end of p-p lnk	*/
#define	lifr_broadaddr	lifr_ifru.lifru_broadaddr	/* broadcast address	*/
#define	lifr_netmask	lifr_ifru.lifru_netmask	/* interface net mask	*/
#define	lifr_flags	lifr_ifru.lifru_flags	/* flags		*/
#define	lifr_metric	lifr_ifru.lifru_ivalue	/* metric		*/
#define	lifr_mtu		lifr_ifru.lifru_mtu	/* mtu			*/
#define lifr_map		lifr_ifru.lifru_map	/* device map		*/
#define lifr_slave	lifr_ifru.lifru_slave	/* slave device		*/
#define	lifr_data	lifr_ifru.lifru_data	/* for use by interface	*/
#define lifr_ifindex	lifr_ifru.lifru_ivalue    /* interface index      */
#define lifr_bandwidth	lifr_ifru.lifru_ivalue	/* link bandwidth	*/
#define lifr_qlen	lifr_ifru.lifru_ivalue	/* queue length		*/


/* Structure used in SIOCGIFCONF request.  Used to retrieve interface
   configuration for machine (useful for programs which must know all
   networks accessible).  */

struct lifconf
  {
    int	lifc_len;			/* Size of buffer.  */
    int lifc_family;
    unsigned long lifc_flags;
    union
      {
	__caddr_t lifcu_buf;
	struct lifreq *lifcu_req;
      } lifc_ifcu;
  };
#define	lifc_buf	lifc_ifcu.lifcu_buf	/* Buffer address.  */
#define	lifc_req	lifc_ifcu.lifcu_req	/* Array of structures.  */


#define SIOCGLIFCONF	0x8972
#define SIOCGLIFFLAGS	0x8973
#define SIOCGLIFADDR	0x8974

#endif /* net/if.h */
