# -*- coding: utf-8 -*-
## AttchmentField
## Copyright (C)2006 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""
AttchmentField
"""
__version__ = "$Revision: 24574 $"
# $Source: /cvsroot/ingeniweb/PloneSubscription/SubscriptionTool.py,v $
# $Id: global_symbols.py 24574 2006-06-08 11:32:11Z roeder $
__docformat__ = 'restructuredtext'


import os
import sys
import string

# Volatile or not volatile ?
_AF_VOLATILE_ = 1

# Check if we have to be in debug mode
if os.path.isfile(os.path.abspath(os.path.dirname(__file__)) + '/debug.txt'):
    DEBUG_MODE = 1
else:
    DEBUG_MODE = 0

# Get version
__version_file_ = open(os.path.abspath(os.path.dirname(__file__)) + '/version.txt', 'r', )
ATTACHMENTFIELD_VERSION = string.strip(__version_file_.read())
__version_file_.close()

# Text programs
if sys.platform == "win32":
    raw_conv = "type"
else:
    raw_conv = "cat"


# Set log options correctly
import Log
if DEBUG_MODE:
    Log.LOG_LEVEL = Log.LOG_DEBUG
else:
    Log.LOG_LEVEL = Log.LOG_NOTICE

from Log import *
Log = Log
Log(LOG_NOTICE, "Starting %s at %d debug level" % (os.path.dirname(__file__), LOG_LEVEL, ))



MAX_PREVIEW_SIZE = 1024 * 5                 # If preview is larger than that, doesn't return it in the getSmallPreview() method

MAX_COLS_EXCEL = 100
MAX_ROWS_EXCEL = 100

# Configlets
from Products.CMFCore import CMFCorePermissions
attachmentfield_prefs_configlet = {
    'id': 'attachmentfield_prefs',
    'appId': "AttachmentField",
    'name': 'AttachmentField Preferences',
    'action': 'string:$portal_url/attachmentfield_prefs_form',
    'category': 'Products',
    'permission': (CMFCorePermissions.ManagePortal,),
    'imageUrl': 'AttachmentField.png',
    }
