##############################################################################
#
# Copyright (c) 2001, 2002 Zope Corporation and Contributors.
# All Rights Reserved.
# 
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
# 
##############################################################################
"""
Revision information:
$Id: DefaultColorizers.py,v 1.2 2002/04/04 01:31:29 chrism Exp $
"""
import re
from string import join, strip, find
from cgi import escape
import Syntax
import parser

debugger_expr=re.compile(r'(^\s*>>> |^\s*pdb> .*)', re.MULTILINE).search
html_line_expr=re.compile(r'<(.*?)>').match
spaces_expr=re.compile(r'^(\s*)').match

kw = [
    "del", "from", "lambda", "return",
    "and", "elif", "global", "not", "try",
    "break", "else", "if", "or", "while",
    "class", "except", "import", "pass",
    "continue", "finally", "in", "print",
    "def", "for", "is", "raise"]
s = r'(\s*' + join(kw, r')|(\s*') + ')'
python_expr=re.compile(s).match

def is_html(source, source_lines):
    slen = float(len(source_lines))
    success_percent = .4
    matched_percent = 0
    give_up_percent = .8
    finished_percent = 0
    blank = 0
    maybe = 0
    nope = 0
    i = 0
    for line in source_lines:
        line = strip(line)
        if not line:
            blank = blank + 1
        elif html_line_expr(line):
            maybe = maybe + 1
        else:
            nope = nope + 1
        # if we have greater than success_percent of lines as HTML
        if maybe:
            matched_percent = maybe/(slen-blank)
            if matched_percent > success_percent:
                return 1
        # if we're most of the way through and there's no hope, give up.
        if finished_percent >= give_up_percent:
            if matched_percent < 1 - give_up_percent:
                return 0
        i = i + 1
        finished_percent = i / slen
    return 0

def is_debugger(source, source_lines):
    if debugger_expr(source):
        return 1
    
def is_python(source, source_lines):
   try:
       parser.suite(join(unindented,'\n'))
   except parser.ParserError:
       return 0
   else:
       return 1

def unindent(source_lines):
   start = 1
   unindented = []
   for line in source_lines:
       if start and strip(line):
           m = spaces_expr(line)
           start, end = m.span()
           indent = end-start
           start = 0
       unindented.append(line[indent:])
   return unindented

def tokenized_example(source, source_lines):
   unindented = join(unindent(source_lines), '\n')
   if find(unindented, 'import Zope, ZPublisher') > 0:
       print join(source_lines, '\n')
   highlighted = Syntax.Parser(unindented)
   highlighted.format()
   return highlighted.out

def simple_example(source, source_lines):
    out = []
    unindented = join(unindent(source_lines), '\n')
    out.append('\n<pre class="simple_example">\n')
    out.append(escape(unindented))
    out.append('\n</pre>\n')
    return join(out, '\n')
