from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import BooleanField, BooleanWidget


journalField = StringField('journal',
                searchable=1,
                required=1,
                widget=StringWidget(label="Journal",
                    label_msgid="label_source_journal",
                    description="A journal name (should be its standard abbreviation).",
                    description_msgid="help_source_journal",
                    i18n_domain="plone",),
                )

volumeField = StringField('volume',
                searchable=1,
                widget=StringWidget(label="Volume",
                    label_msgid="label_source_volume",
                    description="The volume of a journal or multivolume book work.",
                    description_msgid="help_source_volume",
                    i18n_domain="plone",),
                )

numberField = StringField('number',
                searchable=1,
                widget=StringWidget(label="Number",
                    label_msgid="label_source_number",
                    description="The number of a journal, magazine, or technical report. An issue of a journal or magazine is usually identified by its volume and number; the organization that issues a technical report usually gives it a number.",
                    description_msgid="help_source_number",
                    i18n_domain="plone",),
                )

pagesField = StringField('pages',
                searchable=1,
                widget=StringWidget(label="Pages",
                    label_msgid="label_source_pages",
                    description="A page number or range of numbers such as '42--111'; you may also have several of these, separating them with commas: '7,41,73--97'. The standard styles convert a single dash to a double.",
                    description_msgid="help_source_pages",
                    i18n_domain="plone",),
                )

howpublishedField = StringField('howpublished',
                      searchable=1,
                      required=0,
                      widget=StringWidget(label="How published",
                          label_msgid="label_source_howpublished",
                          description="For publications without a publisher. e.g., an 'Institute Report'.",
                          description_msgid="help_source_howpublished",
                          i18n_domain="plone",),
                    )

publisherField = StringField('publisher',
                    searchable=1,
                    required=1,
                    widget=StringWidget(label="Publisher",
                        label_msgid="label_source_publisher",
                        description="The publisher's name.",
                        description_msgid="help_source_publisher",
                        i18n_domain="plone",),
                    )

addressField = StringField('address',
                    searchable=1,
                    widget=StringWidget(label="Address",
                        label_msgid="label_source_address",
                        description="Publisher's address. For major publishing houses, just the city is given. For small publishers, you can help the reader by giving the complete address.",
                        description_msgid="help_source_address",
                        i18n_domain="plone",),
                    )

editionField = StringField('edition',
                    searchable=1,
                    widget=StringWidget(label="Edition",
                        label_msgid="label_source_edition",
                        description="The edition of a book - for example, 'second'.",
                        description_msgid="help_source_edition",
                        i18n_domain="plone",),
                    )

booktitleField = StringField('booktitle',
                   searchable=1,
                   widget=StringWidget(label="Book Title",
                       label_msgid="label_source_booktitle",
                       description="Title of a book, part of which is being cited.",
                       description_msgid="help_source_booktitle",
                       i18n_domain="plone",),
                )

editorField = StringField('editor',
                searchable=1,
                widget=StringWidget(label="Editor",
                    label_msgid="label_source_editor",
                    description="Name(s) of editor(s). If there is also an 'author' field, then the 'editor' field gives the editor of the book or collection in which the reference appears.",
                    description_msgid="help_source_editor",
                    i18n_domain="plone",),
                )

seriesField = StringField('series',
                searchable=1,
                widget=StringWidget(label="Series",
                    label_msgid="label_source_series",
                    description="The name of a series or set of books. When citing an entire book, the the 'title' field gives its title and an optional 'series' field gives the name of a series in which the book is published.",
                    description_msgid="help_source_series",
                    i18n_domain="plone",),
                )

chapterField = StringField('chapter',
                    searchable=0,
                    widget=StringWidget(label="Chapter",
                        label_msgid="label_source_chapter",
                        description="A chapter number.",
                        description_msgid="help_source_chapter",
                        i18n_domain="plone",),
                    )

organizationField = StringField('organization',
                    searchable=1,
                    required=0,
                    widget=StringWidget(label="Organization",
                        label_msgid="label_source_organization",
                        description="The organization sponsoring a conference.",
                        description_msgid="help_source_organization",
                        i18n_domain="plone",),
                    )

schoolField = StringField('school',
                    searchable=1,
                    required=1,
                    widget=StringWidget(label="School",
                        label_msgid="label_source_school",
                        description="The name of the school where a thesis was written.",
                        description_msgid="help_source_school",
                        i18n_domain="plone",),
                    )

institutionField = StringField('institution',
                     searchable=1,
                     required=1,
                     widget=StringWidget(label="Institution",
                        label_msgid="label_source_institution",
                        description="The institution that published the work.",
                        description_msgid="help_source_institution",
                        i18n_domain="plone",),
                     )

typeField = StringField('type',
                searchable=1,
                widget=StringWidget(label="Type",
                    label_msgid="label_source_type",
                    description="The type of a technical report - for example, 'Research Note'.",
                    description_msgid="help_source_type",
                    i18n_domain="plone",),
                )

editor_flagField = BooleanField('editor_flag',
                    default=0,
                    widget=BooleanWidget(label="Editor Flag",
                        label_msgid="label_editor_flag",
                        description="Check here if the author(s) specified above are actually the editor(s) of the book.",
                        description_msgid="help_editor_flag",
                        i18n_domain="plone",)
                        )
