##########################################################################
#                                                                        #
#           copyright (c) 2003 ITB, Humboldt-University Berlin           #
#           written by: Raphael Ritz, r.ritz@biologie.hu-berlin.de       #
#                                                                        #
##########################################################################

"""Phdthesis reference main class"""

from AccessControl import ClassSecurityInfo
from Products.CMFCore.permissions import View
from Products.Archetypes.public import Schema
from Products.Archetypes.public import StringField, StringWidget
from Products.Archetypes.public import registerType

from Products.CMFBibliographyAT.content.base import BaseEntry
from Products.CMFBibliographyAT.content.schemata \
    import HeaderSchema, AuthorSchema, CoreSchema, TrailingSchema
from Products.CMFBibliographyAT.content.fields \
    import schoolField, addressField


SourceSchema = Schema((
    schoolField,
    addressField,
     ))

PhdthesisSchema = HeaderSchema + AuthorSchema + CoreSchema +  \
                  SourceSchema + TrailingSchema


class PhdthesisReference(BaseEntry):
    """ content type to make reference to a PhD thesis.
    """
    security = ClassSecurityInfo()
    archetype_name = "Phdthesis Reference"
    source_fields = ('school', 'address')

    schema = PhdthesisSchema

    security.declareProtected(View, 'Source')
    def Source(self):
        """ the default source renderer
        """
        try:
            return self.PhdthesisSource()
        except AttributeError:
            school  = self.getSchool()
            address = self.getAddress()
            
            source = "Phd thesis, %s, %s." % (school, address)
            
            return source.replace(', .','.')


registerType(PhdthesisReference)
