#############################################################################
#
# __init__.py   Initialization code for CMFLDAP
#
# This software is governed by a license. See
# LICENSE.txt for the terms of this license.
#
##############################################################################

__doc__     = """ CMFLDAP initialization module """
__version__ = '$Revision: 1.6 $'[11:-2]

from Products.CMFCore import utils, CMFCorePermissions
from Products.CMFCore.DirectoryView import registerDirectory
import LDAPMemberDataTool
import LDAPMembershipTool

try:
    # Do we have Plone? If yes, make the Plone tool available
    import PloneLDAPMembershipTool
    tools = ( PloneLDAPMembershipTool.PloneLDAPMembershipTool
            , LDAPMembershipTool.LDAPMembershipTool
            , LDAPMemberDataTool.LDAPMemberDataTool
            )
except ImportError:
    tools = ( LDAPMembershipTool.LDAPMembershipTool
            , LDAPMemberDataTool.LDAPMemberDataTool
            )

cmfldap_globals = globals()

# Make the skins available as DirectoryViews
registerDirectory('skins', globals())
registerDirectory('skins/cmfldap', globals())


def initialize(context):
    """ Initializing the CMF LDAP Componentry """

    utils.ToolInit( 'CMF LDAP Tools'
                  , tools=tools
                  , product_name='CMFLDAP'
                  , icon='tool.gif'
                  ).initialize(context)

