__doc__ = """ExtFile initialization module. """
__version__ = '1.1.x'

# Step #1: import your Python class so we can refer to it later

import ExtFile
import ExtImage 

# Step #2: define the initialize() function. 

def initialize(context): 
    """Initialize the ExtFile product."""
    
    try: 
        """Try to register the product."""
        
        context.registerClass(
            ExtFile.ExtFile,                        # Which is the addable bit? 
            constructors = (                        # The first of these is called 
                ExtFile.manage_addExtFileForm,      # when someone adds the product; 
                ExtFile.manage_addExtFile),         # the second is named here so we 
                                                    # can give people permission to call it. 
            icon = 'www/extFile.gif'                # This icon was provided by the 
            )                                       # Zope 1 product-in-Python demo. 
            
        context.registerClass(
            ExtImage.ExtImage,                      # Which is the addable bit? 
            constructors = (                        # The first of these is called 
                ExtImage.manage_addExtImageForm,    # when someone adds the product; 
                ExtImage.manage_addExtImage),       # the second is named here so we 
                                                    # can give people permission to call it. 
            icon = 'www/extImage.gif'               # This icon was provided by the 
            )                                       # Zope 1 product-in-Python demo. 
            
    
    except:
        """If you can't register the product, tell someone."""
        
        import sys, traceback, string
        type, val, tb = sys.exc_info()
        sys.stderr.write(string.join(traceback.format_exception(type, val, tb), ''))
        del type, val, tb
