
from Testing import ZopeTestCase

import os, sys, tempfile

from Products.ExtFile import ExtFile, Config
ExtFile.ExtFile._repository = ['reposit']
ExtFile.REPOSITORY = Config.FLAT
ExtFile.REPOSITORY_EXTENSIONS = Config.MIMETYPE_REPLACE
ExtFile.UNDO_POLICY = Config.BACKUP_ON_DELETE
            
here = os.getcwd() # Will this work will all testrunners?
gifImage = here + '/data/Folder_icon.gif'
jpegImage = here + '/data/Teneriffa_small.jpg'
            
            
        
class LocalInstanceHome(ZopeTestCase.ZopeTestCase):
            
    local_home = here #tempfile.gettempdir()
            
    def setupLocalEnvironment(self):
        try:
            import App.config
        except ImportError:
            # Modify builtins
            b = getattr(__builtins__, '__dict__', __builtins__)
            self._ih = INSTANCE_HOME
            b['INSTANCE_HOME'] = self.local_home
        else:
            # Zope 2.7+
            cfg = App.config.getConfiguration()
            self._ih = cfg.instancehome
            cfg.instancehome = self.local_home
            App.config.setConfiguration(cfg)

    def afterClear(self):
        try:
            import App.config
        except ImportError:
            # Restore builtins
            b = getattr(__builtins__, '__dict__', __builtins__)
            if hasattr(self, '_ih'):
                b['INSTANCE_HOME'] = self._ih
        else:
            # Zope 2.7+
            cfg = App.config.getConfiguration()
            if hasattr(self, '_ih'):
                cfg.instancehome = self._ih
            App.config.setConfiguration(cfg)
     


class TestBase(LocalInstanceHome):
        
    def afterSetUp(self):
        LocalInstanceHome.setupLocalEnvironment(self)
        self._nuke_reposit = 1
        
    def afterClear(self):
        if getattr(self, '_nuke_reposit', 0):
            # Remove repository
            repository = os.path.join(INSTANCE_HOME, 'reposit')
            if os.path.isdir(repository): 
                import shutil
                shutil.rmtree(repository, 1)
            del self._nuke_reposit
        LocalInstanceHome.afterClear(self)
        
    def _fsname(self, id):
        return os.path.join(INSTANCE_HOME, 'reposit', id)
        
    def _exists(self, id):
        return os.path.isfile(self._fsname(id))
        
    def _listdir(self):
        return os.listdir(os.path.join(INSTANCE_HOME, 'reposit'))
        
    def _fsize(self, id):
        return os.stat(id)[6]
        
    def addExtFile(self, id, file):
        # Add an ExtFile
        dispatcher = self.folder.manage_addProduct['ExtFile']
        dispatcher.manage_addExtFile(id=id, file=file)
        self.failUnless(hasattr(self.folder, id))
        self.image = self.folder[id]
        
    def addExtImage(self, id, file):
        # Add an ExtImage
        dispatcher = self.folder.manage_addProduct['ExtFile']
        dispatcher.manage_addExtImage(id=id, file=file)
        self.failUnless(hasattr(self.folder, id))
        self.image = self.folder[id]

