#
# Extensible User Folder
# 
# CMF memberdata_tool wrapper Property Source for exUserFolder
#
# (C) Copyright 2000,2001 The Internet (Aust) Pty Ltd
# ACN: 082 081 472	ABN: 83 082 081 472
# All Rights Reserved
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# Author: alan runyan <runyaga@runyaga.com>
# $Id: cmfPropSource.py,v 1.5 2002/11/25 16:15:11 davidcoe Exp $

__version__ = '0.02'
DEBUG = 0 

from Globals import HTMLFile, MessageDialog, Acquisition
from OFS.Folder import Folder
from Products.exUserFolder.exUserFolder import exUserFolder
from Products.exUserFolder.Plugins import PluginRegister
from Products.CMFCore.utils import getToolByName

manage_addPropSourceForm=HTMLFile('manage_addcmfPropSourceForm', globals())

manage_addcmfPropSourceForm=HTMLFile('manage_addcmfPropSourceForm', globals())
manage_editcmfPropSourceForm=HTMLFile('manage_editcmfPropSourceForm', globals())


def manage_addcmfPropSource(self, REQUEST):
	""" Add a portal_memberdata wrapper """

	o = cmfPropSource()

	self._setObject('cmfPropSource', o, None, None, 0)
	o = getattr(self, 'cmfPropSource')

	if hasattr(o, 'postInitialisation'):
		o.postInitialisation(REQUEST)
	self.currentPropSource = o


class cmfPropSource(Folder):
	""" Store User Data in portal_memberdata tool """

	meta_type='Property Source'
	title='portal_memberdata Properties'
	icon ='misc_/CMFCore/tool.gif'	
	manage_editForm=manage_editcmfPropSourceForm
	manage_tabs=Acquisition.Acquired

	def __init__(self):
		self.id='cmfPropSource'
		self.title='portal_memberdata wrapper'
		
	def __str__(self):
		return 'exUserFolder that wraps memberdata'
	
	def hasProperty(self, key):
		return self.getToolByName(self, 'portal_memberdata').hasProperty(key)

	def setProperty(self, key, value):
		if DEBUG: 'setProperty on propSource', key, str(value)
		pass

	def setTempProperty(self, key, value):
		pass

	def flushTempProperties(self):
		pass

	def delProperty(self, key):
		if DEBUG: 'delProperty on propSource', key
		self.delUserProperty(key=key, username=self.name)

	def delUserProperty(self, key, username):
		pass

	def getProperty(self, key, default=None):
		return getToolByName(self, 'portal_memberdata').getProperty(key, default)

	def listProperties(self):
		prop_ids = []
		for t in self.getToolByName(self, 'portal_memberdata').propertyItems():
			prop_ids.append(t[0])
		return props
	
	def getUserProperty(self, key, username, default = None):
		member = getToolByName(self, 'portal_membership').getMemberById(username)
		return getattr(member, key, default)

	def setUserProperty(self, key, username, value):
		if DEBUG: print 'setUserProperty', username, str(key), str(value)
		member = getToolByName(self, 'portal_membership').getMemberById(username)
		setattr(member, key, value)

	def listUserProperties(self, username):
		props=[]
		member = getToolByName(self, 'portal_membership').getMemberById(username)
		for p in getToolByName(self, 'portal_memberdata').propertyItems():
			if hasattr(member, p[0]):
				props.append(p[0])
		return props

	def createUser(self, username, REQUEST):
		""" disabled because CMF plumbing does this before we are reached """
		pass

	def deleteUsers(self, userids):
		""" you can delete a user and then prune the memberdata, this is not impl'd """
		pass

	def updateUser(self, username, REQUEST):
		""" set member's properties from a mapping """
		if DEBUG: print 'updateUser ', username, str(REQUEST.keys())
		map = {}
		for prop in REQUEST.keys():
			if prop[:5]=='user_': 
				map[prop[5:]]=self.REQUEST[prop]
		getToolByName(self, 'portal_membership').getMemberById(username).setMemberProperties(map)
	
	def postInitialisation(self, REQUEST):
		""" currently isnt getting called.. why? """
		if DEBUG: 'init and tried to override manage_editcmfPropSourceForm'
		manage_editcmfPropSourceForm = getattr( getToolByName(self, 'portal_memberdata')
												, 'manage_propertiesForm' )

cmfPropReg=PluginRegister('cmfPropSource',
						  'portal_memberdata wrapper',
						  cmfPropSource, manage_addcmfPropSourceForm,
						  manage_addcmfPropSource, 
						  manage_editcmfPropSourceForm )

exUserFolder.propSources['cmfPropSource']=cmfPropReg

