from AccessControl import ClassSecurityInfo

try:
    from Products.LinguaPlone.public import *
except ImportError:
    from Products.Archetypes.public import *


schema = BaseSchema + Schema((
    TextField('body',
              required = 1,
              searchable = 1,
              default_output_type = 'text/html',
              allowable_content_types = ('text/plain',
                                         'text/restructured',
                                         'text/html',
                                         'application/msword'),
              widget = RichWidget(description = "Enter or upload text for the body of the document."),
             ),
    StringField('contactName',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName2',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName3',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName4',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName5',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('langIndependentInBase',
                languageIndependent = 1,
                widget = StringWidget(description = "This field is language independent in SimpleType.")
               ),
    StringField('langIndependentInDerived',
                languageIndependent = 0,
                widget = StringWidget(description = "This field is not language independent in SimpleType.")
               ),
    StringField('langIndependentInBoth',
                languageIndependent = 1,
                widget = StringWidget(description = "This field is language independent everywhere.")
               ),
    ))

class SimpleType(BaseContent):
    """A simple multilingual archetype"""
    schema = schema

    security = ClassSecurityInfo()

    def setContactName(self, value, **kw):
        """Set contact name. This tests language independent method generation """
        self.getField('contactName').set(self, value, **kw)
        self.testing = value

registerType(SimpleType)


schema = SimpleType.schema.copy()
schema['langIndependentInBase'].languageIndependent = 0
schema['langIndependentInDerived'].languageIndependent = 1

class DerivedType(SimpleType):
    """A simple multilingual archetype"""
    schema = schema

    security = ClassSecurityInfo()

registerType(DerivedType)


schema = BaseSchema

class SimpleFolder(BaseFolder):
    """A simple folderish multilingual archetype"""
    schema = schema

    security = ClassSecurityInfo()

registerType(SimpleFolder)


schema = BaseSchema

class OrderedFolder(OrderedBaseFolder):
    """A simple ordered-folderish multilingual archetype"""
    schema = schema

    security = ClassSecurityInfo()

registerType(OrderedFolder)


schema = BaseSchema

class BTreeFolder(BaseBTreeFolder):
    """A simple btree-folderish multilingual archetype"""
    schema = schema

    security = ClassSecurityInfo()

registerType(BTreeFolder)

