# $Id$
#
# Migration script to propagate language independent fields data from
# the canonical object to all the translations.
#
# At portal root add a new ExternalMethod:
#
#   - Id: fixAccessors
#   - Module Name: LinguaPlone.fixAccessors
#   - Function Name: run
#
# Then save the changes and click on the 'Test' tab. That's it! :-)
#
# PS: You can also fine-tune the migration by calling the ExternalMethod
# with additional parameters (they're forwarded to the catalog query).
#
# The following can be used in a PythonScript to migrate only Image/Files:
#
# context.fixAccessors(portal_type=['Image', 'File'])
#

from Products.CMFPlone.interfaces.Translatable import ITranslatable

def run(self, **kwargs):

    migrated = []
    updated = []

    kwargs.update({'Language': 'all'})
    results = self.portal_catalog(**kwargs)

    for r in results:

        # Objects without a language are not affected
        if not r.Language:
            continue

        # Wake up the object
        o = r.getObject()

        # Skip non ITranslatable objects
        if not ITranslatable.isImplementedBy(o):
            o._p_deactivate()
            continue

        # Skip canonicals objects
        if o.isCanonical():
            o._p_deactivate()
            continue

        # Wake up the canonical for the current translation
        c = o.getCanonical()
        uid = c.UID()

        # Skip already migrated canonicals
        if uid in migrated:
            o._p_deactivate()
            c._p_deactivate()
            continue

        # Iterate ober language independent fields
        schema = c.Schema()
        independent_fields = schema.filterFields(languageIndependent=True)
        for field in independent_fields:
            # Look up the correct canonical accessor
            accessor = field.getEditAccessor(c)
            if not accessor:
                accessor = field.getAccessor(c)
            # Get the data
            data = accessor()
            # Iterate over the non canonical translations
            for t, state in c.getNonCanonicalTranslations().values():
                # Look up the tranlation mutator
                translation_mutator = getattr(t, field.translation_mutator)
                # Set the new data
                translation_mutator(data)

        # Reindex the related objects
        for t, state in c.getTranslations().values():
            t.reindexObject()
            updated.append(t.absolute_url())
            t._p_deactivate()

        # Mark canonical as migrated
        migrated.append(uid)

    updated.insert(0, '%s objects updated:' % len(updated))
    return '\n'.join(updated)
