from Products.CMFCore.utils import ContentInit
from Products.CMFCore.DirectoryView import registerDirectory

from Products.LinguaPlone.public import *
from Products.LinguaPlone import config
from Products.LinguaPlone import permissions

# Make sure installer imports
from Products.LinguaPlone.Extensions import Install as _Install
del _Install

def initialize(context):
    # Apply monkey patches
    from Products.LinguaPlone import patches

    if config.IS_PLONE_2_0:
        # It's a Plone 2.0, apply compatibility patches.
        from Products.LinguaPlone.plone20 import tool

    # Register directory views
    registerDirectory('skins', config.GLOBALS)

    if config.INSTALL_DEMO_TYPES:
        import examples

    # Initialize content types
    content_types, constructors, ftis = process_types(
        listTypes(config.PKG_NAME), config.PKG_NAME)

    ContentInit(
        '%s Content' % config.PKG_NAME,
        content_types = content_types,
        permission = permissions.AddPortalContent,
        extra_constructors = constructors,
        fti = ftis,
    ).initialize(context)
