from Products.PloneArticle import install_globals, PloneArticle
from Products.PloneArticle.global_symbols import*
from Products.PloneArticle.Installation import Installation
from Products.StandardCacheManagers import RAMCacheManager
from OFS.Cache import Cache
from Products.CMFCore.utils import getToolByName
from cStringIO import StringIO
from Products.PloneArticle.PloneArticleTool import addPloneArticleTool

fti_list = (
    PloneArticle.factory_type_information,
    )
fti_list2 = (
    PloneArticle.factory_type_information2,
    )
types_list = (
    "PloneArticle",
    )
skin_name = "PloneArticle"
perms_list = (PloneArticle_addPermission, PloneArticle_editPermission, PloneArticle_lockPermission)

product_name = "PloneArticle"

def setupTools(self):
    tool = 'PloneArticle Tool'
    id = "portal_article"
    found=0
    for obj in self.objectValues():
        if obj.meta_type == tool:
            self.manage_delObjects([id, ])
    addPloneArticleTool(self)

def setupRamCacheManager(self, out,):
        meta_type = RAMCacheManager.RAMCacheManager.meta_type
        skinsTool = getToolByName(self, 'portal_skins')
        
        obj =  skinsTool['PloneArticle']
        if 'PloneArticleThumbRAMCache' not in self.objectIds(meta_type):
            out.write('Installing PloneArticleThumbRAMCache\n')
            RAMCacheManager.manage_addRAMCacheManager(self, 'PloneArticleThumbRAMCache')
            """
            obj['getThumbTag'].ZCacheable_setManagerId(self.PloneArticleThumbRAMCache.getId())
            obj['getFirstThumbTag'].ZCacheable_setManagerId(self.PloneArticleThumbRAMCache.getId())
            out.write(obj['getFirstThumbTag'].absolute_url() + ' added in PloneArticleThumbRAMCache\n')
            out.write(obj['getThumbTag'].absolute_url() + ' added in PloneArticleThumbRAMCache\n')
            """
        else:
            out.write('PloneArticleThumbRAMCache already installed\n')   


def install(self):
    installation=Installation(self)
    out = installation.out
    installation.setPermissions(perms_list)
    installation.setupTypesandSkins(fti_list, skin_name, install_globals, fti_list2)
    
    if not installation.isPlone2():
        for ctype in types_list:
            validation = [
                  ('%s_editForm' % (ctype), 'validate_id,validate_%s_edit' % ctype, ),
                  ('%s_attachmentForm' % (ctype,), 'validate_%s_attachment' % ctype, ),
                  ('%s_imageForm' % (ctype,), 'validate_%s_image' % ctype, ), 
                  ('%s_modelForm' % (ctype,), 'validate_%s_model' % ctype, ), 
                  ]
            installation.addFormValidators(validation)
            lowertype=ctype.lower()
            transitions = [
                  ('%s.%s_editForm.success' % (lowertype, ctype ), 'script:%s_edit' % (ctype), ),
                  ('%s.%s_editForm.failure' % (lowertype, ctype ), '%s_editForm' % (ctype), ),
                  ('%s.%s_edit.success' % (lowertype, ctype ), 'action:view', ),
                  ('%s.%s_edit.failure' % (lowertype, ctype ), 'action:edit', ),
                  ('%s.%s_attachmentForm.success' % (lowertype, ctype ), 'script:%s_editAttachment' % (ctype), ),             # Attachment-related forms
                  ('%s.%s_attachmentForm.failure' % (lowertype, ctype ), '%s_attachmentForm' % (ctype), ),
                  ('%s.%s_editAttachment.success' % (lowertype, ctype ), 'action:attach', ),
                  ('%s.%s_editAttachment.failure' % (lowertype, ctype ), 'action:attach', ),
                  ('%s.%s_imageForm.success' % (lowertype, ctype ), 'script:%s_editImage' % (ctype), ),             # Image-related forms
                  ('%s.%s_imageForm.failure' % (lowertype, ctype ), '%s_imageForm' % (ctype), ),
                  ('%s.%s_editImage.success' % (lowertype, ctype ), 'action:image', ),
                  ('%s.%s_editImage.failure' % (lowertype, ctype ), 'action:image', ),
                  ('%s.%s_modelForm.success' % (lowertype, ctype ), 'script:%s_editModel' % (ctype), ),             # Model-related forms
                  ('%s.%s_modelForm.failure' % (lowertype, ctype ), '%s_modelForm' % (ctype), ),
                  ('%s.%s_editModel.success' % (lowertype, ctype ), 'action:model', ),
                  ('%s.%s_editModel.failure' % (lowertype, ctype ), 'action:model', ),
                  ]
            installation.addNavigationTransitions(transitions)
    else:
        # Lock icon for Plone >= 2 only
        installation.addActionIcon(
            category='plone',
            action_id='toggle_article_lock',
            icon_expr='lock_icon.gif',
            title='Toggle Lock',
            priority=0
            )
    setupRamCacheManager(self, out)
    setupTools(self) 

    return installation.report()

